% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turbine_influences.R
\name{get_dist_angles}
\alias{get_dist_angles}
\title{Calculate distances and angles of possibly influencing turbines}
\usage{
get_dist_angles(t, o, wnkl, dist, polYgon, plotAngles = FALSE)
}
\arguments{
\item{t}{A data.frame of the current individual with X and Y coordinates}

\item{o}{A numeric value indicating the index of the current turbine}

\item{wnkl}{The angle from which wake influences are considered to be
negligible}

\item{dist}{A numeric value indicating the distance, after which the wake
effects are considered to be eliminated.}

\item{polYgon}{A shapefile representing the considered area}

\item{plotAngles}{A logical variable, which is used to plot the distances and
angles. Default is \code{FALSE}}
}
\value{
Returns a matrix with the distances, angles and heights of potentially
influencing turbines
}
\description{
Calculate distances and angles for a turbine and all it's
potentially influencing turbines.
}
\examples{
library(sf)

## Exemplary input Polygon with 2km x 2km:
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(4498482, 4498482, 4499991, 4499991, 4498482),
    c(2668272, 2669343, 2669343, 2668272, 2668272)
  ))),
  crs = 3035
))

## Create a random windfarm with 10 turbines
t <- st_coordinates(st_sample(Polygon1, 10))
t <- cbind(t, "Z" = 1)
wnkl <- 20
dist <- 100000

## Evaluate and plot for every turbine all other potentially influencing turbines
potInfTur <- list()
for (i in 1:(length(t[, 1]))) {
  potInfTur[[i]] <- get_dist_angles(
    t = t, o = i, wnkl = wnkl,
    dist = dist, polYgon = Polygon1, plotAngles = TRUE
  )
}
potInfTur

}
\seealso{
Other Wind Energy Calculation Functions: 
\code{\link{barometric_height}()},
\code{\link{calculate_energy}()},
\code{\link{circle_intersection}()},
\code{\link{turbine_influences}()}
}
\concept{Wind Energy Calculation Functions}
