test_that("load_params works with default file", {
  params <- load_params()
  expect_type(params, "list")
  expect_true("random_forest" %in% names(params))
})

test_that("load_params works with custom file", {
  custom_yaml <- tempfile(fileext = ".yaml")
  writeLines("
station: \"TEST001\"
random_forest:
  n_trees: 50
  mtry: 2
  min_node_size: 3
target: \"PM2.5\"
  ", con = custom_yaml)

  params <- load_params(custom_yaml)
  expect_equal(params$random_forest$n_trees, 50)
  expect_equal(params$target, "PM2.5")
})

test_that("load_params errors with non-existent file", {
  expect_error(load_params("nonexistent.yaml"))
})
