% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoise2.R
\name{denoise2}
\alias{denoise2}
\title{Total Variation Denoising for Image}
\usage{
denoise2(
  data,
  lambda = 1,
  niter = 100,
  method = c("TVL1.PrimalDual", "TVL2.PrimalDual", "TVL2.FiniteDifference"),
  normalize = FALSE
)
}
\arguments{
\item{data}{standard 2d or 3d array.}

\item{lambda}{regularization parameter (positive real number).}

\item{niter}{total number of iterations.}

\item{method}{indicating problem and algorithm combination.}

\item{normalize}{a logical; \code{TRUE} to make the range in \eqn{[0,1]}, or \code{FALSE} otherwise.}
}
\value{
denoised array as same size of \code{data}.
}
\description{
Given an image \code{f}, it solves an optimization of the form,
\deqn{u^* = argmin_u E(u,f)+\lambda V(u)}
where \eqn{E(u,f)} is fidelity term and \eqn{V(u)} is total variation regularization term.
The naming convention of a parameter \code{method} is \code{<problem type>} + \code{<name of algorithm>}.
For more details, see the section below.
}
\section{Data format}{

An input \code{data} can be either (1) 2-dimensional matrix representaing \emph{grayscale} image, or (2) 3-dimensional array
for \emph{color} image.
}

\section{Algorithms for TV-L1 problem}{

The cost function for TV-L2 problem is
\deqn{min_u |u-f|_1 + \lambda |\nabla u|}
where for a given 2-dimensional array, \eqn{|\nabla u| = \sum sqrt(u_x^2 + u_y^2)}
Algorithms (in conjunction with model type) for this problems are \describe{
  \item{\code{"TVL1.PrimalDual"}}{Primal-Dual algorithm.}
}
}

\section{Algorithms for TV-L2 problem}{

The cost function for TV-L2 problem is
\deqn{min_u |u-f|_2^2 + \lambda |\nabla u|}
and algorithms (in conjunction with model type) for this problems are \describe{
  \item{\code{"TVL2.PrimalDual"}}{Primal-Dual algorithm.}
  \item{\code{"TVL2.FiniteDifference"}}{Finite Difference scheme with fixed point iteration.}
}
}

\examples{
\dontrun{
## Load grey-scale 'lena' data
data(lena128)

## Add white noise
sinfo   <- dim(lena128)   # get the size information
xnoised <- lena128 + array(rnorm(128*128, sd=10), sinfo)

## apply denoising models
xproc1 <- denoise2(xnoised, lambda=10, method="TVL2.FiniteDifference")
xproc2 <- denoise2(xnoised, lambda=10, method="TVL1.PrimalDual")

## compare
gcol = gray(0:256/256)
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(lena128, main="original", col=gcol)
image(xnoised, main="noised", col=gcol)
image(xproc1, main="TVL2.FiniteDifference", col=gcol)
image(xproc2, main="TVL1.PrimalDual", col=gcol)
par(opar)
}

}
\references{
\insertRef{rudin_nonlinear_1992}{tvR}

\insertRef{chambolle_first-order_2011}{tvR}
}
