% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_wormhole.R
\name{ts_aug_wormhole}
\alias{ts_aug_wormhole}
\title{Augmentation by wormhole}
\usage{
ts_aug_wormhole()
}
\value{
a \code{ts_aug_wormhole} object.
}
\description{
Time series data augmentation is a technique used to increase the size and diversity of a time series dataset by creating new instances of the original data through transformations or modifications. The goal is to improve the performance of machine learning models trained on time series data by reducing overfitting and improving generalization.
Wormhole does data augmentation by removing lagged terms and adding old terms.
}
\examples{
library(daltoolbox)
data(tsd)

#convert to sliding windows
xw <- ts_data(tsd$y, 10)

#data augmentation using flip
augment <- ts_aug_wormhole()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
