% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_perspective}
\alias{transform_perspective}
\title{Perspective transformation of an image}
\usage{
transform_perspective(
  img,
  startpoints,
  endpoints,
  interpolation = 2,
  fill = NULL
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{startpoints}{(list of list of ints): List containing four lists of two
integers corresponding to four corners
\verb{[top-left, top-right, bottom-right, bottom-left]} of the original image.}

\item{endpoints}{(list of list of ints): List containing four lists of two
integers corresponding to four corners
\verb{[top-left, top-right, bottom-right, bottom-left]} of the transformed
image.}

\item{interpolation}{(int, optional) Desired interpolation. An integer
\code{0 = nearest}, \code{2 = bilinear}, and \code{3 = bicubic} or a name from
\code{\link[magick:options]{magick::filter_types()}}.}

\item{fill}{(int or str or tuple): Pixel fill value for constant fill.
Default is 0. If a tuple of length 3, it is used to fill R, G, B channels
respectively. This value is only used when the padding_mode is constant.
Only int value is supported for Tensors.}
}
\description{
Perspective transformation of an image
}
\seealso{
Other transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_color_jitter}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_five_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_random_affine}()},
\code{\link{transform_random_apply}()},
\code{\link{transform_random_choice}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_erasing}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_order}()},
\code{\link{transform_random_perspective}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()},
\code{\link{transform_resize}()},
\code{\link{transform_resized_crop}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_ten_crop}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{transforms}
