% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_map.R
\name{generate_map}
\alias{generate_map}
\title{Generate a Single Tile Map}
\usage{
generate_map(
  data,
  square = TRUE,
  flat_topped = FALSE,
  prop = 0,
  interpolate = 1,
  smoothness = 0,
  shift = c(0, 0)
)
}
\arguments{
\item{data}{An object of class \code{sfc_MULTIPOLYGON} or
\code{sfc_POLYGON}, which contains the regions that make up the original
map.}

\item{square}{logical. If \code{TRUE}, generates a square tile map. If
\code{FALSE}, generates a hexagon tile map.}

\item{flat_topped}{logical. If \code{TRUE}, hexagons are flat-topped. If
\code{FALSE}, hexagons are pointy-topped.}

\item{prop}{A proportion used in specifying the standard deviation of
the Gaussian noise added to original region centroids. The standard
deviation of the Gaussian noise is calculated as the mean distance between
a region centroid and its neighboring regions' centroids multiplied by the
value provided for the \code{prop} argument.}

\item{interpolate}{A number between 0 and 1 controlling the linear
interpolation between the noisy region centroids and fully-transformed
region centroids. If 0, noisy region centroids are used. If 1,
fully-transformed centroids are used.}

\item{smoothness}{numeric. Controls the bandwidth of the Gaussian kernel
used for smoothing the transformed boundary polygon. The bandwidth is
calculated as the mean distance between adjacent boundary points
multiplied by the value provided for the \code{smoothness} argument.}

\item{shift}{A numeric vector of length two specifying the number of grid
steps to shift the candidate tile map in the x and y directions before
counting the number of tile centroids that lie within the transformed
boundary.}
}
\value{
Returns an object of class \code{sfc_POLYGON}, containing the tiles of
  the tile map in the same order as the original regions given to the
  function.
}
\description{
Generate a single square or hexagon tile map.
}
\details{
Implements an algorithm for generating tile maps proposed in
\emph{"Generating Tile Maps"} (McNeill and Hale 2017). The regions of the
map must be contiguous. Coordinates cannot be in terms of latitude and
longitude. Instead the coordinate reference system must be an appropriate
planar projection.
}
\examples{
library(sf)
northeast <- governors[c(6,7,17,18,19,27,28,30,36,37,43),]
northeast$tile_map <- generate_map(northeast$geometry, square = FALSE,
                                   flat_topped = TRUE)

}
\references{
McNeill, Graham, and Scott A Hale. 2017. “Generating Tile Maps.”
 In \emph{Computer Graphics Forum}, 36:435–45. 3. Wiley Online Library.
}
