% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_prop.R
\name{percent}
\alias{percent}
\alias{add_prop}
\title{Add percentage to counts in data.frame}
\usage{
percent(x, digits = 1)

add_prop(.data, count_name = last(names(.data)), digits = 1)
}
\arguments{
\item{x}{A number (numeric).}

\item{digits}{How many digits to keep in the percentage. Default uses 1.}

\item{.data}{A data frame.}

\item{count_name}{Column name of counts (Character).
Default uses the last column of data.frame.}
}
\description{
Add percentage for counts in the data.frame, both numeric and
 character with `%` would be provided.
}
\examples{

 percent(0.9057)
 percent(0.9057,3)

 iris \%>\%
   count_dt(Species) \%>\%
   add_prop()

 iris \%>\%
   count_dt(Species) \%>\%
   add_prop(count_name = "n",digits = 2)

}
\references{
https://stackoverflow.com/questions/7145826/how-to-format-a-number-as-percentage-in-r
}
