% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smith_waterman.R
\name{smith_waterman_misaligned}
\alias{smith_waterman_misaligned}
\title{Extract misaligned elements}
\usage{
smith_waterman_misaligned(x, type = c("a", "b"))
}
\arguments{
\item{x}{an object of class \code{smith_waterman} as returned by \code{\link{smith_waterman}}}

\item{type}{either 'a' or 'b' indicating to return elements misaligned from \code{a} or from \code{b}}
}
\value{
a list of character vectors of misaligned elements
\itemize{
\item{before_alignment: }{Sections in a or b which were occurring before the alignment}
\item{wrong_alignment: }{Sections in a or b which were mismatched in the alignment}
\item{after_alignment: }{Sections in a or b which were occurring after the alignment}
\item{combined: }{The combination of \code{before_alignment}, \code{wrong_alignment} and \code{after_alignment}}
\item{partial: }{Logical, where TRUE indicates that there is at least a partial alignment and FALSE indicating no alignment between \code{a} and \code{b} was done (alignment score of 0)}
}
}
\description{
Extract misaligned elements from the Smith-Waterman alignment, namely
\itemize{
\item{before_alignment: }{Sections in a or b which were occurring before the alignment}
\item{wrong_alignment: }{Sections in a or b which were mismatched in the alignment}
\item{after_alignment: }{Sections in a or b which were occurring after the alignment}
}
}
\examples{
sw <- smith_waterman("ab test xy", "cd tesst ab", type = "characters")
sw
misses <- smith_waterman_misaligned(sw, type = "a")
str(misses)
misses <- smith_waterman_misaligned(sw, type = "b")
str(misses)

a <- system.file(package = "text.alignment", "extdata", "example1.txt")
a <- readLines(a)
a <- paste(a, collapse = "\n")
b <- system.file(package = "text.alignment", "extdata", "example2.txt")
b <- readLines(b)
b <- paste(b, collapse = "\n")
sw <- smith_waterman(a, b, type = "characters")
smith_waterman_misaligned(sw, type = "a")
smith_waterman_misaligned(sw, type = "b")
}
