% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_default_stats_formats_labels.R
\docType{data}
\name{default_stats_formats_labels}
\alias{default_stats_formats_labels}
\alias{get_stats}
\alias{get_stat_names}
\alias{get_formats_from_stats}
\alias{get_labels_from_stats}
\alias{get_indents_from_stats}
\alias{tern_default_stats}
\alias{tern_default_formats}
\alias{tern_default_labels}
\alias{summary_formats}
\alias{summary_labels}
\title{Get default statistical methods and their associated formats, labels, and indent modifiers}
\format{
\itemize{
\item \code{tern_default_stats} is a named list of available statistics, with each element
named for their corresponding statistical method group.
}

\itemize{
\item \code{tern_default_formats} is a named vector of available default formats, with each element
named for their corresponding statistic.
}

\itemize{
\item \code{tern_default_labels} is a named \code{character} vector of available default labels, with each element
named for their corresponding statistic.
}
}
\usage{
get_stats(
  method_groups = "analyze_vars_numeric",
  stats_in = NULL,
  custom_stats_in = NULL,
  add_pval = FALSE
)

get_stat_names(stat_results, stat_names_in = NULL)

get_formats_from_stats(
  stats,
  formats_in = NULL,
  levels_per_stats = NULL,
  tern_defaults = tern_default_formats
)

get_labels_from_stats(
  stats,
  labels_in = NULL,
  levels_per_stats = NULL,
  label_attr_from_stats = NULL,
  tern_defaults = tern_default_labels
)

get_indents_from_stats(
  stats,
  indents_in = NULL,
  levels_per_stats = NULL,
  tern_defaults = as.list(rep(0L, length(stats))) \%>\% setNames(stats),
  row_nms = lifecycle::deprecated()
)

tern_default_stats

tern_default_formats

tern_default_labels

summary_formats(type = "numeric", include_pval = FALSE)

summary_labels(type = "numeric", include_pval = FALSE)
}
\arguments{
\item{method_groups}{(\code{character})\cr indicates the statistical method group (\code{tern} analyze function)
to retrieve default statistics for. A character vector can be used to specify more than one statistical
method group.}

\item{stats_in}{(\code{character})\cr statistics to retrieve for the selected method group. If custom statistical
functions are used, \code{stats_in} needs to have them in too.}

\item{custom_stats_in}{(\code{character})\cr custom statistics to add to the default statistics.}

\item{add_pval}{(\code{flag})\cr should \code{"pval"} (or \code{"pval_counts"} if \code{method_groups} contains
\code{"analyze_vars_counts"}) be added to the statistical methods?}

\item{stat_results}{(\code{list})\cr list of statistical results. It should be used close to the end of
a statistical function. See examples for a structure with two statistical results and two groups.}

\item{stat_names_in}{(\code{character})\cr custom modification of statistical values.}

\item{stats}{(\code{character})\cr statistical methods to return defaults for.}

\item{formats_in}{(named \code{vector})\cr custom formats to use instead of defaults. Can be a character vector with
values from \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} or custom format functions. Defaults to \code{NULL} for any rows
with no value is provided.}

\item{levels_per_stats}{(named \code{list} of \code{character} or \code{NULL})\cr named list where the name of each element is a
statistic from \code{stats} and each element is the levels of a \code{factor} or \code{character} variable (or variable name),
each corresponding to a single row, for which the named statistic should be calculated for. If a statistic is only
calculated once (one row), the element can be either \code{NULL} or the name of the statistic. Each list element will be
flattened such that the names of the list elements returned by the function have the format \code{statistic.level} (or
just \code{statistic} for statistics calculated for a single row). Defaults to \code{NULL}.}

\item{tern_defaults}{(\code{list} or \code{vector})\cr defaults to use to fill in missing values if no user input is given.
Must be of the same type as the values that are being filled in (e.g. indentation must be integers).}

\item{labels_in}{(named \code{character})\cr custom labels to use instead of defaults. If no value is provided, the
variable level (if rows correspond to levels of a variable) or statistic name will be used as label.}

\item{label_attr_from_stats}{(named \code{list})\cr if \code{labels_in = NULL}, then this will be used instead. It is a list
of values defined in statistical functions as default labels. Values are ignored if \code{labels_in} is provided or \code{""}
values are provided.}

\item{indents_in}{(named \code{integer})\cr custom row indent modifiers to use instead of defaults. Defaults to \code{0L} for
all values.}

\item{row_nms}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecation cycle started. See the \code{levels_per_stats} parameter
for details.}

\item{type}{(\code{string})\cr \code{"numeric"} or \code{"counts"}.}

\item{include_pval}{(\code{flag})\cr same as the \code{add_pval} argument in \code{\link[=get_stats]{get_stats()}}.}
}
\value{
\itemize{
\item \code{get_stats()} returns a \code{character} vector of statistical methods.
}

\itemize{
\item \code{get_stat_names()} returns a named list of \code{character} vectors, indicating the names of
statistical outputs.
}

\itemize{
\item \code{get_formats_from_stats()} returns a named list of formats as strings or functions.
}

\itemize{
\item \code{get_labels_from_stats()} returns a named list of labels as strings.
}

\itemize{
\item \code{get_indents_from_stats()} returns a named list of indentation modifiers as integers.
}

\itemize{
\item \code{summary_formats()} returns a named \code{vector} of default statistic formats for the given data type.
}

\itemize{
\item \code{summary_labels} returns a named \code{vector} of default statistic labels for the given data type.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Utility functions to get valid statistic methods for different method groups
(\code{.stats}) and their associated formats (\code{.formats}), labels (\code{.labels}), and indent modifiers
(\code{.indent_mods}). This utility is used across \code{tern}, but some of its working principles can be
seen in \code{\link[=analyze_vars]{analyze_vars()}}. See notes to understand why this is experimental.
}
\details{
Current choices for \code{type} are \code{counts} and \code{numeric} for \code{\link[=analyze_vars]{analyze_vars()}} and affect \code{get_stats()}.

\verb{summary_*} quick get functions for labels or formats uses \code{get_stats} and \code{get_labels_from_stats} or
\code{get_formats_from_stats} respectively to retrieve relevant information.
}
\section{Functions}{
\itemize{
\item \code{get_stats()}: Get statistics available for a given method
group (analyze function). To check available defaults see \code{tern::tern_default_stats} list.

\item \code{get_stat_names()}: Get statistical \emph{names} available for a given method
group (analyze function). Please use the \verb{s_*} functions to get the statistical names.

\item \code{get_formats_from_stats()}: Get formats corresponding to a list of statistics.
To check available defaults see list \code{tern::tern_default_formats}.

\item \code{get_labels_from_stats()}: Get labels corresponding to a list of statistics.
To check for available defaults see list \code{tern::tern_default_labels}.

\item \code{get_indents_from_stats()}: Get row indent modifiers corresponding to a list of statistics/rows.

\item \code{tern_default_stats}: Named list of available statistics by method group for \code{tern}.

\item \code{tern_default_formats}: Named vector of default formats for \code{tern}.

\item \code{tern_default_labels}: Named \code{character} vector of default labels for \code{tern}.

\item \code{summary_formats()}: Quick function to retrieve default formats for summary statistics:
\code{\link[=analyze_vars]{analyze_vars()}} and \code{\link[=analyze_vars_in_cols]{analyze_vars_in_cols()}} principally.

\item \code{summary_labels()}: Quick function to retrieve default labels for summary statistics.
Returns labels of descriptive statistics which are understood by \code{rtables}. Similar to \code{summary_formats}.

}}
\note{
These defaults are experimental because we use the names of functions to retrieve the default
statistics. This should be generalized in groups of methods according to more reasonable groupings.

Formats in \code{tern} and \code{rtables} can be functions that take in the table cell value and
return a string. This is well documented in \code{vignette("custom_appearance", package = "rtables")}.
}
\examples{
# analyze_vars is numeric
num_stats <- get_stats("analyze_vars_numeric") # also the default

# Other type
cnt_stats <- get_stats("analyze_vars_counts")

# Weirdly taking the pval from count_occurrences
only_pval <- get_stats("count_occurrences", add_pval = TRUE, stats_in = "pval")

# All count_occurrences
all_cnt_occ <- get_stats("count_occurrences")

# Multiple
get_stats(c("count_occurrences", "analyze_vars_counts"))

stat_results <- list(
  "n" = list("M" = 1, "F" = 2),
  "count_fraction" = list("M" = c(1, 0.2), "F" = c(2, 0.1))
)
get_stat_names(stat_results)
get_stat_names(stat_results, list("n" = "argh"))

# Defaults formats
get_formats_from_stats(num_stats)
get_formats_from_stats(cnt_stats)
get_formats_from_stats(only_pval)
get_formats_from_stats(all_cnt_occ)

# Addition of customs
get_formats_from_stats(all_cnt_occ, formats_in = c("fraction" = c("xx")))
get_formats_from_stats(all_cnt_occ, formats_in = list("fraction" = c("xx.xx", "xx")))

# Defaults labels
get_labels_from_stats(num_stats)
get_labels_from_stats(cnt_stats)
get_labels_from_stats(only_pval)
get_labels_from_stats(all_cnt_occ)

# Addition of customs
get_labels_from_stats(all_cnt_occ, labels_in = c("fraction" = "Fraction"))
get_labels_from_stats(all_cnt_occ, labels_in = list("fraction" = c("Some more fractions")))

get_indents_from_stats(all_cnt_occ, indents_in = 3L)
get_indents_from_stats(all_cnt_occ, indents_in = list(count = 2L, count_fraction = 5L))
get_indents_from_stats(
  all_cnt_occ,
  indents_in = list(a = 2L, count.a = 1L, count.b = 5L)
)

summary_formats()
summary_formats(type = "counts", include_pval = TRUE)

summary_labels()
summary_labels(type = "counts", include_pval = TRUE)

}
\seealso{
\link{formatting_functions}
}
\keyword{datasets}
