% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_step.R
\name{control_step}
\alias{control_step}
\title{Control function for subgroup treatment effect pattern (STEP) calculations}
\usage{
control_step(
  biomarker = NULL,
  use_percentile = TRUE,
  bandwidth,
  degree = 0L,
  num_points = 39L
)
}
\arguments{
\item{biomarker}{(\code{numeric} or \code{NULL})\cr optional provision of the numeric biomarker variable, which
could be used to infer \code{bandwidth}, see below.}

\item{use_percentile}{(\code{flag})\cr if \code{TRUE}, the running windows are created according to
quantiles rather than actual values, i.e. the bandwidth refers to the percentage of data
covered in each window. Suggest \code{TRUE} if the biomarker variable is not uniformly
distributed.}

\item{bandwidth}{(\code{numeric(1)} or \code{NULL})\cr indicating the bandwidth of each window.
Depending on the argument \code{use_percentile}, it can be either the length of actual-value
windows on the real biomarker scale, or percentage windows.
If \code{use_percentile = TRUE}, it should be a number between 0 and 1.
If \code{NULL}, treat the bandwidth to be infinity, which means only one global model will be fitted.
By default, \code{0.25} is used for percentage windows and one quarter of the range of the \code{biomarker}
variable for actual-value windows.}

\item{degree}{(\code{integer(1)})\cr the degree of polynomial function of the biomarker as an interaction term
with the treatment arm fitted at each window. If 0 (default), then the biomarker variable
is not included in the model fitted in each biomarker window.}

\item{num_points}{(\code{integer(1)})\cr the number of points at which the hazard ratios are estimated. The
smallest number is 2.}
}
\value{
A list of components with the same names as the arguments, except \code{biomarker} which is
just used to calculate the \code{bandwidth} in case that actual biomarker windows are requested.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for STEP calculations.
}
\examples{
# Provide biomarker values and request actual values to be used,
# so that bandwidth is chosen from range.
control_step(biomarker = 1:10, use_percentile = FALSE)

# Use a global model with quadratic biomarker interaction term.
control_step(bandwidth = NULL, degree = 2)

# Reduce number of points to be used.
control_step(num_points = 10)

}
