% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_merge_call.R
\name{get_merge_call}
\alias{get_merge_call}
\title{Get merge call from a list of selectors}
\usage{
get_merge_call(
  selector_list,
  join_keys = teal.data::join_keys(),
  dplyr_call_data = get_dplyr_call_data(selector_list, join_keys = join_keys),
  merge_function = "dplyr::full_join",
  anl_name = "ANL"
)
}
\arguments{
\item{selector_list}{(\code{reactive})
output from \code{\link[=data_extract_multiple_srv]{data_extract_multiple_srv()}} or a reactive named list of
outputs from \code{\link[=data_extract_srv]{data_extract_srv()}}.
When using a reactive named list, the names must be identical to the shiny
ids of the respective
\code{\link[=data_extract_ui]{data_extract_ui()}}.}

\item{join_keys}{(\code{join_keys}) nested list of keys used for joining.}

\item{dplyr_call_data}{(\code{list}) simplified selectors with aggregated set of filters.}

\item{merge_function}{(\code{character(1)} or \code{reactive})
A character string of a function that accepts the arguments
\code{x}, \code{y} and \code{by} to perform the merging of datasets.}

\item{anl_name}{(\code{character(1)})
Name of the analysis dataset.}
}
\value{
List with merge \code{call} elements.
}
\description{
Creates list of calls depending on selector(s) and type of the merge.
The merge order is the same as in selectors passed to the function.
}
