% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_prod_oth_prices.R
\name{nl_prod_oth_prices}
\alias{nl_prod_oth_prices}
\title{A function to download the Productivity and other societal Reference prices of the Dutch Costing Manual for one or multiple years}
\usage{
nl_prod_oth_prices(
  year = "all",
  category = "all",
  unit = "all",
  currency = c("EUR", "INT$")
)
}
\arguments{
\item{year}{The year of which the reference price should be downloaded, multiple years are possible, default is the whole dataset}

\item{category}{The category of prices that should be included (one or more categories), default is including all categories}

\item{unit}{The reference price that should be included (one or multiple reference prices),  default is including the whole dataframe}

\item{currency}{The currency in which the reference price should be included (EUR or INT$), default is EUR}
}
\value{
A dataframe or value with the Productivity and/other societal Reference price(s) of the Dutch Costing Manual
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function downloads the Productivity and other societal Reference prices of the Dutch Costing Manual for one or multiple years. The prices are available in Euro (EUR) or International Dollar (INT$).
}
\examples{
# Example usage of the nl_prod_oth_prices function:
# Calculate for 2023 with the category Productivity loss - Paid work in EUR
nl_prod_oth_prices(year = "2023", category = "Productivity loss - Paid work")

# Calculate for 2022 and 2023 with the category Productivity loss - Paid work in EUR
nl_prod_oth_prices(year = "all", category = "Productivity loss - Paid work")

# Calculate for 2022 with the category Productivity loss - Paid work in INT$
nl_prod_oth_prices(year = "2022", category = "Productivity loss - Paid work", currency = "INT$")

}
\keyword{Costing}
\keyword{Dutch}
\keyword{Family}
\keyword{Generic}
\keyword{Patient}
\keyword{Prices}
\keyword{Productivity}
\keyword{Societal}
