% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_imputaiton.R
\name{localImputation}
\alias{localImputation}
\title{Function to generate imputations using non-parametric and semi-parametric local imputation methods.}
\usage{
localImputation(
  i,
  preds,
  y,
  delta,
  bw = NULL,
  kernel = c("gaussian", "uniform", "triangular")
)
}
\arguments{
\item{i}{integer referring to the index of the missing value to be imputed.}

\item{preds}{numeric vector of predictions of missing values from SuperLearner.}

\item{y}{numeric vector for variable to be imputed.}

\item{delta}{binary vector of length \code{length(y)} indicating missingness.
\code{1} where \code{y} is observed and \code{0} where \code{y} is missing.}

\item{bw}{\code{NULL} or numeric value for bandwidth of kernel function (as standard deviations of the kernel).}

\item{kernel}{one of \code{gaussian}, \code{uniform}, or \code{triangular}.
Specifies the kernel to be used in estimating the distribution around a missing value.}
}
\value{
numeric vector of randomly drawn imputed values.
}
\description{
Function to generate imputations using non-parametric and semi-parametric local imputation methods.
}
