% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statcan_search.R
\name{statcan_search}
\alias{statcan_search}
\title{Searching function for statcanR}
\usage{
statcan_search(keywords, lang)
}
\arguments{
\item{keywords}{The words that appear in the title or description of the data table}

\item{lang}{The language wanted}
}
\value{
The output will be the title, id, description, and release date of a table
}
\description{
The \code{statcan_search()} function has 2 arguments to fulfill to find a database: {keywords} and {lang}.
The keywords argument refers to words that can be found in either the title or the description of the database. For example, inserting the keywords
"economy","export",and "link" will bring up the title, table id, description, and release date for databases that include these keywords. In this case, only one data table ("Supply and use tables, link-1997 level")
would be returned as it is the only data table containing all three words.
}
\details{
Easily connect to Statistics Canada's Web Data Service with R. Open economic data (formerly known as CANSIM tables, now identified by Product IDs (PID)) are accessible as a data frame, directly in the user's R environment.
}
\examples{
statcan_search(c("economy","export","link"),"eng")
}
