% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vespa}
\alias{vespa}
\title{The VESPA dataset}
\format{
A \code{\link[tibble]{tibble}} with 320 rows and 7 columns:
\itemize{
\item \code{V}: a categorical variable with two levels specifying the ID of the
\code{Volunteer};
\item \code{E}: a categorical variable with two levels specifying the ID of the
\code{Experimenter};
\item \code{S}: a categorical variable with four levels specifying the type of
\code{Sensor};
\item \code{P}: a categorical variable with four levels specifying the \code{Position} of
the sensor;
\item \code{A}: a categorical variable with two levels specifying the ID of the
\code{Acquisition} pathway;
\item \code{R}: a categorical variable with 5 levels specifying the ID of the
\code{Repetition};
\item \code{igp}: A 101x5 \code{\link[tibble]{tibble}} storing a QTS which
represents the IGP of the individual under a specific set of VESPA
conditions.
}
}
\usage{
vespa
}
\description{
A set of QTS representing individual gait patterns (IGPs) of individuals
collected under a number of varying factors.
}
\details{
The IGP measures the hip rotation during a typical gait cycle. Each rotation
is expressed with respect to the mean position of the sensor during the gait
cycle. Each IGP is then straightened so that it is periodic with a last point
matching the first one.
}
\keyword{datasets}
