% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_response_curves.R
\name{plot_response_curves}
\alias{plot_response_curves}
\title{Plots the response curves of a model.}
\usage{
plot_response_curves(
  model = NULL,
  variables = NULL,
  quantiles = c(0.1, 0.5, 0.9),
  grid.resolution = 200,
  line.color = viridis::viridis(length(quantiles), option = "F", end = 0.9),
  ncol = 2,
  show.data = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{variables}{Character vector, names of predictors to plot. If \code{NULL}, the most important variables (importance higher than the median) in \code{x} are selected. Default: \code{NULL}.}

\item{quantiles}{Numeric vector with values between 0 and 1, argument \code{probs} of \link[stats]{quantile}. Quantiles to set the other variables to. Default: \code{c(0.1, 0.5, 0.9)}}

\item{grid.resolution}{Integer between 20 and 500. Resolution of the plotted curve Default: \code{100}}

\item{line.color}{Character vector with colors, or function to generate colors for the lines representing \code{quantiles}. Must have the same number of colors as \code{quantiles} are defined. Default: \code{viridis::viridis(length(quantiles), option = "F", end = 0.9)}}

\item{ncol}{Integer, argument of \link[patchwork]{wrap_plots}. Defaults to the rounded squared root of the number of plots. Default: \code{2}}

\item{show.data}{Logical, if \code{TRUE}, the observed data is plotted along with the response curves. Default: \code{FALSE}}

\item{verbose}{Logical, if TRUE the plot is printed. Default: \code{TRUE}}
}
\value{
A list with slots named after the selected \code{variables}, with one ggplot each.
}
\description{
Plots the response curves of models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or  \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
All variables that are not plotted in a particular response curve are set to the values of their respective quantiles, and the response curve for each one of these quantiles is shown in the plot. When the input model was fitted with \code{\link[=rf_repeat]{rf_repeat()}} with \code{keep.models = TRUE}, then the plot shows the median of all model runs, and each model run separately as a thinner line. The output list can be plotted all at once with \code{patchwork::wrap_plots(p)} or \code{cowplot::plot_grid(plotlist = p)}, or one by one by extracting each plot from the list.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)

#fitting a random forest model
m <- rf(
 data = plant_richness_df,
 dependent.variable.name = "richness_species_vascular",
 predictor.variable.names = colnames(plant_richness_df)[5:21],
 n.cores = 1,
 verbose = FALSE
)

#response curves of most important predictors
plot_response_curves(model = m)

}
}
\seealso{
\code{\link[=plot_response_surface]{plot_response_surface()}}
}
