% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{single_matern5}
\alias{single_matern5}
\title{Matern covariance function (scalar - nu = 5/2)}
\usage{
single_matern5(d, sigsq, phi)
}
\arguments{
\item{d}{a scalar representing the distance on which it is desired to
evaluate the covariance function.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,
controls the range of the spatial dependence.}
}
\value{
a scalar representing the (matern) covariance between two
observations \code{d} apart of each other.
}
\description{
Computing the Matern covariance function for a single distance
measure, with \eqn{\nu = 5/2}.
}
\seealso{
\code{\link{single_matern}}, \code{\link{single_matern3}}
\code{\link{single_exp}}, \code{\link{mat_cov}}
}
\keyword{internal}
