% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log-lik.R
\name{singl_log_lik}
\alias{singl_log_lik}
\title{Evaluate log-lik}
\usage{
singl_log_lik(
  theta,
  .dt,
  dists,
  npix,
  model,
  nu = NULL,
  tr = NULL,
  kappa = 1,
  mu2 = 1.5,
  apply_exp = FALSE
)
}
\arguments{
\item{theta}{a \code{numeric} vector of size 4 (\eqn{\mu, \sigma^2, \alpha,
\phi}) containing the parameters associated with the model.}

\item{.dt}{a \code{numeric} vector containing the variable \eqn{Y}.}

\item{dists}{a \code{list} of size distance matrices at the point level.}

\item{npix}{a \code{integer vector} containing the number of pixels within
each polygon. (Ordered by the id variables for the polygons).}

\item{model}{a \code{character} indicating which covariance function to
use. Possible values are \code{c("matern", "pexp", "gaussian",
    "spherical", "cs", "gw", "tapmat")}.}

\item{nu}{\eqn{\nu} parameter. Not necessary if \code{model} is
\code{"gaussian"} or \code{"spherical"}}

\item{tr}{\eqn{\theta_r} taper range.}

\item{kappa}{\eqn{\kappa \in \{0, \ldots, 3 \}} parameter for the GW cov
function.}

\item{mu2}{the smoothness parameter \eqn{\mu} for the GW function.}

\item{apply_exp}{a \code{logical} indicating whether the exponential
transformation should be applied to variance parameters. This
facilitates the optimization process.}
}
\value{
a scalar representing \code{-log.lik}.
}
\description{
Evaluate the log-likelihood for a given set of parameters
}
\details{
Internal use.
}
\keyword{internal}
