% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{obtener_meses_mas_casos}
\alias{obtener_meses_mas_casos}
\title{Obtener los meses con mayor número de casos}
\usage{
obtener_meses_mas_casos(
  data_event,
  col_fechas,
  col_casos = "casos",
  top = 1,
  concat_vals = TRUE
)
}
\arguments{
\item{data_event}{Un `data.frame` con los datos de la enfermedad
o evento.}

\item{col_fechas}{Un `array` (arreglo) de `character` (cadena de caracteres)
con los nombres de las columnas que contienen las fechas en los datos de la
enfermedad o evento.}

\item{col_casos}{Un `character` (cadena de caracteres) con el nombre de la
columna de los datos de la enfermedad o evento que contiene el número
de casos; su valor por defecto es `"casos"`.}

\item{top}{Un `numeric` (numérico) que contiene la cantidad máxima
de meses a retornar; su valor por defecto es `3`.}

\item{concat_vals}{Un `logical` (`TRUE` o `FALSE`) que indica si se requiere
concatenar los meses como una cadena; su valor por defecto es `TRUE`.}
}
\value{
Un `data.frame` que contiene los meses con mayor número de casos.
}
\description{
Función que obtiene los meses con el mayor número de casos
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
casos_inisintomas <- agrupar_fecha_inisintomas(data_limpia)
obtener_meses_mas_casos(
  data_event = casos_inisintomas,
  col_fechas = "ini_sin",
  col_casos = "casos",
  top = 3,
  concat_vals = TRUE
)
}
