% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_likelihood_biomee.R
\name{cost_likelihood_biomee}
\alias{cost_likelihood_biomee}
\title{Log-likelihood cost function for BiomeE with different targets}
\usage{
cost_likelihood_biomee(par, obs, drivers, targets)
}
\arguments{
\item{par}{A vector containing parameter values for \code{'phiRL',
'LAI_light', 'tf_base', 'par_mort'} in that order, and for the error terms
corresponding to the target variables, e.g. \code{'err_GPP'} if GPP is a target. 
Make sure that
the order of the error terms in \code{par} coincides with the order provided in
the \code{targets} argument.}

\item{obs}{A nested data frame of observations, following the structure of \code{biomee_validation},
for example.}

\item{drivers}{A nested data frame of driver data, for example \code{biomee_gs_leuning_drivers}.}

\item{targets}{A character vector indicating the target variables for which the
optimization will be done. This should be a subset of \code{c("GPP", "LAI",
"Density", "Biomass")}.}
}
\value{
The log-likelihood of the simulated 
targets by the biomee model versus the observed targets.
}
\description{
Cost function for parameter calibration, which
computes the log-likelihood for the biomee model fitting several target 
variables for a given set of parameters.
}
\details{
The cost function performs a BiomeE model run for the value of
\code{par} given as argument. The likelihood is calculated assuming that the 
predicted targets are independent, normally distributed and centered on the observations. 
The optimization 
should be run using \code{BayesianTools}, so the likelihood is maximized.
}
\examples{
\donttest{
# Compute the likelihood for a set of
# BiomeE model parameter values
# and the example data
cost_likelihood_biomee(
 par = c(3.5, 3.5, 1, 1,    # model params
         0.5),              # err_GPP
 obs = biomee_validation,
 drivers = biomee_gs_leuning_drivers,
 targets = c("GPP")
)
}
}
