% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_balanced_blocks.R
\name{create_balanced_blocks}
\alias{create_balanced_blocks}
\title{Create balanced blocks}
\usage{
create_balanced_blocks(g, force = "force", bigraph = bigraph)
}
\arguments{
\item{g}{An igraph object. The network for which embeddings will be found}

\item{force}{A character vector. The name of the node attribute that is the force exerted by the nodes}

\item{bigraph}{A list. the list of biconnected components produced by the biconnected_components function.
This function take a non trivial amount of time on large graphs so this pass through minimises the function being called.}
}
\value{
A list containing all the bi connected component where each component is balanced to have a net force of 0.
}
\description{
Separates the network into a series of bi-connected components that can be solved separately. 
Solving smaller subgraphs using the bi-connected component method reduces the risk of network divergence.
This function is seldom called independently of setse_bicomp
}
\details{
When networks are separated into the bi-connected subgraphs or blocks. The overall network balance needs to be maintained. 
\code{create_balanced_blocks} maintains the balance by summing the net force across the all the nodes that are being removed from
the subgraph. Therefore a node that is an articulation point has a force value equal to the total of all the nodes on the adjacent
bi-connected component.
}
\examples{
library(igraph)
#create a list of balanced network using the biconnected_network dataset
balanced_list <-create_balanced_blocks(biconnected_network, 
bigraph = biconnected_components(biconnected_network))

#count the edges in each of the bi-components
sapply(balanced_list, ecount)

}
