% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutates.R
\name{update_tidy_omic}
\alias{update_tidy_omic}
\title{Update Tidy Omic}
\usage{
update_tidy_omic(tidy_omic, updated_tidy_data, new_variable_tables = c())
}
\arguments{
\item{tidy_omic}{an object of class tidy_omic produced by
\code{\link{create_tidy_omic}}}

\item{updated_tidy_data}{a tibble of data to use to update \code{tidy_omic}.}

\item{new_variable_tables}{a named character vector of newly added variables
in \code{updated_tidy_data} (names) and the table {features, samples,
measurements} they apply to (values).}
}
\value{
a \code{tidy_omic} object with an updated schema and/or data.
}
\description{
Update a Tidy 'Omics data and schema to reflect newly added fields.
}
\examples{

library(dplyr)

tidy_omic <- brauer_2008_tidy
updated_tidy_data <- tidy_omic$data \%>\%
  mutate(new_sample_var = "foo") \%>\%
  select(-DR)
new_variable_tables <- c("new_sample_var" = "samples")
}
