% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_read_load.R
\name{rxp_load}
\alias{rxp_load}
\title{Load output of a derivation}
\usage{
rxp_load(derivation_name, which_log = NULL, project_path = ".")
}
\arguments{
\item{derivation_name}{Character, the name of the derivation.}

\item{which_log}{Character, defaults to NULL. If NULL the most recent
build log is used. If a string is provided, it's used as a
regular expression to match against available log files.}

\item{project_path}{Character, defaults to ".".
Path to the root directory of the project.}
}
\value{
Nothing, this function has the side effect of loading objects into
the parent frame.
}
\description{
Loads the output of derivations in the parent frame of the
current session, returns a path if reading directly is not possible.
}
\details{
When \code{derivation_name} points to a single R object, it gets loaded
in the current session using \code{assign(..., envir = parent.frame())}, which
corresponds to the global environment in a regular interactive session. If
you're trying to load a Python object and \code{{reticulate}} is available,
\code{reticulate::py_load_object()} is used and then the object gets loaded into
the global environment. In case the derivation is pointing to several
outputs (which can happen when building a Quarto document for example) or
loading fails, the path to the object is returned instead.
}
\examples{
\dontrun{
  # Load an R object
  rxp_load("mtcars")

  # Load a Python object
  rxp_load("my_python_model")

  # Load from a specific build log
  rxp_load("mtcars", which_log = "2025-05-10")
}
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
