% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_require.R
\name{py_require}
\alias{py_require}
\title{Declare Python Requirements}
\usage{
py_require(
  packages = NULL,
  python_version = NULL,
  ...,
  exclude_newer = NULL,
  action = c("add", "remove", "set")
)
}
\arguments{
\item{packages}{A character vector of Python packages to be available during
the session. These can be simple package names like \code{"jax"} or names with
version constraints like \code{"jax[cpu]>=0.5"}. Pip style syntax for installing
from local files or a git repository is also supported (see details).}

\item{python_version}{A character vector of Python version constraints \cr
(e.g., \code{"3.10"} or \code{">=3.9,<3.13"}).}

\item{...}{Reserved for future extensions; must be empty.}

\item{exclude_newer}{Limit package versions to those published before a
specified date. This offers a lightweight alternative to freezing package
versions, helping guard against Python package updates that break a
workflow. Accepts strings formatted as RFC 3339 timestamps (e.g.,
\code{"2006-12-02T02:07:43Z"}) and local dates in the same format (e.g.,
\code{"2006-12-02"}) in your system's configured time zone. Once \code{exclude_newer}
is set, only the \code{set} action can override it.}

\item{action}{Determines how \code{py_require()} processes the provided
requirements. Options are:
\itemize{
\item \code{"add"} (the default): Adds the entries to the current set of requirements.
\item \code{"remove"}: Removes \emph{exact} matches from the requirements list.
Requests to remove nonexistent entries are ignored. For example, if
\code{"numpy==2.2.2"} is in the list, passing \code{"numpy"} with \code{action="remove"}
will not remove it.
\item \code{"set"}: Clears all existing requirements and replaces them with the
provided ones. Packages and the Python version can be set independently.
}}
}
\value{
\code{py_require()} is primarily called for its side effect of modifying
the manifest of "Python requirements" for the current R session  that
reticulate maintains internally. \code{py_require()} usually returns \code{NULL}
invisibly. If \code{py_require()} is called with no arguments, it returns the
current manifest--a list with names \code{packages}, \code{python_version}, and
\code{exclude_newer.} The list also has a class attribute, to provide a print
method.
}
\description{
\code{py_require()} allows you to declare Python requirements for the R session,
including Python packages, any version constraints on those packages, and any
version constraints on Python itself. Reticulate can then automatically
create and use an ephemeral Python environment that satisfies all these
requirements.
}
\details{
Reticulate will only use an ephemeral environment if no other Python
installation is found earlier in the \href{https://rstudio.github.io/reticulate/articles/versions.html#order-of-discovery}{Order of Discovery}.
You can also force reticulate to use an ephemeral environment by setting
\code{Sys.setenv(RETICULATE_PYTHON="managed")}, or you can disable reticulate from
using an ephemeral environment by setting
\code{Sys.setenv(RETICULATE_USE_MANAGED_VENV="no")}.

The ephemeral virtual environment is not created until the user interacts
with Python for the first time in the R session, typically when \code{import()} is
first called.

If \code{py_require()} is called with new requirements after reticulate has
already initialized an ephemeral Python environment, a new ephemeral
environment is activated on top of the existing one. Once Python is
initialized, only adding packages is supported---removing packages, changing
the Python version, or modifying \code{exclude_newer} is not possible.

Calling \code{py_require()} without arguments returns a list of the currently
declared requirements.

R packages can also call \code{py_require()} (e.g., in \code{.onLoad()} or elsewhere)
to declare Python dependencies. The print method for \code{py_require()} displays
the Python dependencies declared by R packages in the current session.
}
\note{
Reticulate uses \href{https://docs.astral.sh/uv/}{\code{uv}} to resolve Python
dependencies. Many \code{uv} options can be customized via environment variables,
as described \href{https://docs.astral.sh/uv/configuration/environment/}{here}.
For example:
\itemize{
\item If temporarily offline, to resolve packages from cache without checking for updates, set: \cr
\code{Sys.setenv(UV_OFFLINE = "1")}.
\item To use an additional package index: \cr
\code{Sys.setenv(UV_INDEX = "https://download.pytorch.org/whl/cpu")}. \cr (To add
multiple additional indexes, \code{UV_INDEX} can be a list of space-separated
urls).
\item To change the default package index: \cr
\code{Sys.setenv(UV_DEFAULT_INDEX = "https://my.org/python-packages-index/")}
\item To allow resolving a prerelease dependency: \cr
\code{Sys.setenv(UV_PRERELEASE = "allow")}.
\item To force \code{uv} to create ephemeral environments using the system python: \cr
\code{Sys.setenv(UV_PYTHON_PREFERENCE = "only-system")}
}

For more advanced customization needs, there’s also the option to configure
\code{uv} with a user-level or system-level \code{uv.toml} file.
\subsection{Installing from alternate sources}{

The \code{packages} argument also supports declaring a dependency from a Git
repository or a local file. Below are some examples of valid \code{packages}
strings:
\itemize{
\item Install Ruff from a specific Git tag:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"git+https://github.com/astral-sh/ruff@v0.2.0"
}\if{html}{\out{</div>}}
\item Install Ruff from a specific Git commit:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"git+https://github.com/astral-sh/ruff@1fadefa67b26508cc59cf38e6130bde2243c929d"
}\if{html}{\out{</div>}}
\item Install Ruff from a specific Git branch:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"git+https://github.com/astral-sh/ruff@main"
}\if{html}{\out{</div>}}
\item Install MarkItDown from the \code{main} branch---find the package in the
subdirectory 'packages/markitdown':

\if{html}{\out{<div class="sourceCode">}}\preformatted{"markitdown@git+https://github.com/microsoft/markitdown.git@main#subdirectory=packages/markitdown"
}\if{html}{\out{</div>}}
\item Install MarkItDown from the local filesystem by providing an absolute path to
a directory containing a \code{pyproject.toml} or \code{setup.py} file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{"markitdown@/Users/tomasz/github/microsoft/markitdown/packages/markitdown/"
}\if{html}{\out{</div>}}
}

See more examples
\href{https://docs.astral.sh/uv/pip/packages/#installing-a-package}{here} and
\href{https://pip.pypa.io/en/stable/cli/pip_install/#examples}{here}.
}

\subsection{Clearing the Cache}{

If \code{uv} is already installed on your machine, \code{reticulate} will use the
existing \code{uv} installation as-is, including its default \verb{cache dir} location.
To clear the caches of a self-managed \code{uv} installation, send the following
system commands to \code{uv}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{uv cache clean
rm -r "$(uv python dir)"
rm -r "$(uv tool dir)"
}\if{html}{\out{</div>}}

If an existing installation of \code{uv} is not found, \code{reticulate} will
automatically download and store it, along with other downloaded artifacts
and ephemeral environments, in the \code{tools::R_user_dir("reticulate", "cache")}
directory. To clear this cache manually, delete the directory:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# delete uv, ephemeral virtual environments, and all downloaded artifacts
unlink(tools::R_user_dir("reticulate", "cache"), recursive = TRUE)
}\if{html}{\out{</div>}}

Reticulate also clears its managed cache automatically on an interval,
defaulting to every 120 days. Configure this interval in \code{.Rprofile} with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(reticulate.max_cache_age = as.difftime(30, units = "days"))
}\if{html}{\out{</div>}}
}
}
