% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mean_direction}
\alias{mean_direction}
\title{Mean Direction}
\usage{
mean_direction(directions, weights = NULL)
}
\arguments{
\item{directions}{numeric vector of directions, in degree, 0° being the North}

\item{weights}{numeric vector, usually wind speed of wave height.}
}
\value{
The (weighted) mean of the values in \code{directions} is computed.
}
\description{
Function for computing the (weighted) arithmetic mean of
directional data in \strong{meteorological convention}.
}
\examples{
# Test with some wind directions (unweighted)
wind_directions <- c(10, 20, 350, 5, 15) # Directions mostly around North
mean_dir <- mean_direction(wind_directions)
cat("Mean wind direction (unweighted):", round(mean_dir, 1), "degrees\n")
wind_directions <- c(350, 10, 20, 340, 30) # Directions around North
wind_speeds <- c(15, 5, 2, 12, 3) # Higher speeds for directions closer to North
mean_dir_weighted <- mean_direction(wind_directions, wind_speeds)
cat("Mean wind direction (weighted):", round(mean_dir_weighted, 1), "degrees\n")

# Compare weighted vs unweighted for the same data
mean_dir_unweighted <- mean_direction(wind_directions)
cat("Same data unweighted:", round(mean_dir_unweighted, 1), "degrees\n")
}
