% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{print.summary_regmedint}
\alias{print.summary_regmedint}
\title{Print method for summary objects from \code{\link{summary.regmedint}}}
\usage{
\method{print}{summary_regmedint}(x, ...)
}
\arguments{
\item{x}{An object of the class \code{summary_regmedint}.}

\item{...}{For compatibility with the generic function.}
}
\value{
Invisibly return the first argument.
}
\description{
Print results contained in a \code{summary_regmedint} object with additional explanation regarding the evaluation settings.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
## Implicit printing
summary(regmedint_obj)
## Explicit printing
print(summary(regmedint_obj))

}
