% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algoInvHist.R
\name{calculateCostHist}
\alias{calculateCostHist}
\title{Calculate costs for a specific combinations of lambda, muVec and sigmaVec.}
\usage{
calculateCostHist(
  lambda,
  muVec,
  sigmaVec,
  HistData,
  alpha = 0.01,
  alphaMcb = 0.1,
  pNormLookup
)
}
\arguments{
\item{lambda}{(numeric) transformation parameter for inverse Box-Cox transformation}

\item{muVec}{(numeric) vector of mean values of non-pathological Gaussian distribution in transformed space}

\item{sigmaVec}{(numeric) vector of sd values of non-pathological Gaussian distribution in transformed space}

\item{HistData}{(list) with histogram data generated by function \code{\link{generateHistData}}}

\item{alpha}{(numeric) specifying the confidence region used for selection of histgram bins in cost calculation}

\item{alphaMcb}{(numeric) specifying the confidence level defining the maximal allowed counts below asymmetric confidence region}

\item{pNormLookup}{(list) with lookup table for pnormApprox function \code{\link{pnormApprox}}}
}
\value{
(numeric) vector with (lambda, mu, sigma, P, cost).
}
\description{
Calculate costs for a specific combinations of lambda, muVec and sigmaVec.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
