% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_plans.R
\name{redist_plans}
\alias{redist_plans}
\title{A set of redistricting plans}
\usage{
redist_plans(plans, map, algorithm, wgt = NULL, ...)
}
\arguments{
\item{plans}{a matrix with \code{n_precinct} columns and \code{n_sims} rows,
or a single vector of precinct assignments.}

\item{map}{a \code{\link{redist_map}} object}

\item{algorithm}{the algorithm used to generate the plans (usually "smc" or "mcmc")}

\item{wgt}{the weights to use, if any.}

\item{...}{Other named attributes to set}
}
\value{
a new \code{redist_plans} object.
}
\description{
A \code{redist_plans} object is essentially a data frame of summary
information on each district and each plan, along with the matrix of district
assignments and information about the simulation process used to generate the
plans.
}
\details{
The first two columns of the data frame will be \code{draw}, a factor indexing
the simulation draw, and \code{district}, an integer indexing the districts
within a plan. The data frame will therefore have \code{n_sims*ndists} rows.
As a data frame, the usual \code{dplyr} methods will work.

Other useful methods for \code{redist_plans} objects:
\itemize{
\item \code{\link{summary.redist_plans}}
\item \code{\link{add_reference}}
\item \code{\link{subset_sampled}}
\item \code{\link{subset_ref}}
\item \code{\link{pullback}}
\item \code{\link{number_by}}
\item \code{\link{match_numbers}}
\item \code{\link{is_county_split}}
\item \code{\link{prec_assignment}}
\item \code{\link{plan_distances}}
\item \code{\link{get_plans_matrix}}
\item \code{\link{get_plans_weights}}
\item \code{\link{get_sampling_info}}
\item \code{\link{as.matrix.redist_plans}}
\item \code{\link{plot.redist_plans}}
}
}
\examples{
data(iowa)

iowa <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05, total_pop = pop)
rsg_plan <- redist.rsg(iowa$adj, iowa$pop, ndists = 4, pop_tol = 0.05)$plan
redist_plans(rsg_plan, iowa, "rsg")

}
\concept{analyze}
