test_that("mkdir works", {
  r <- httr2::request("https://cloud.example.com")
  expect_equal(
    httr2::with_mocked_responses(mock_mkdir, wd_mkdir(r, "new")),
    TRUE
  )
})

test_that("mkdir warning", {
  r <- httr2::request("https://cloud.example.com")
  expect_warning(
    httr2::with_mocked_responses(mock_mkdir, wd_mkdir(r, "old/new")),
    "Conflict"
  )
})

test_that("mkdir return false", {
  r <- httr2::request("https://cloud.example.com")
  expect_equal(
    httr2::with_mocked_responses(
      mock_mkdir, suppressWarnings(wd_mkdir(r, "old/new"))
    ),
    FALSE
  )
})
