% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_functions.R
\name{growth}
\alias{growth}
\alias{exponential}
\alias{ricker}
\alias{gompertz}
\title{Population Growth Functions}
\usage{
exponential(x, r, ...)

ricker(x, r, K, A = NA)

gompertz(x, r, K, A = NA)
}
\arguments{
\item{x}{number of individuals}

\item{r}{intrinsic population growth rate}

\item{...}{not used, added for compatibility reasons}

\item{K}{carrying capacity}

\item{A}{coefficient of Allee effect (A <= 0: weak, A > 0: strong, NA: none)}
}
\value{
Object of the same dimensions as \code{x} that contains expected number
of individuals in the next time step.
}
\description{
Population growth functions are used during simulation
conducted by the \code{\link{sim}} function.
The user is required  to specify the name of a growth function while initialising the
\code{sim_data} object using \code{\link{initialise}}.
}
\details{
\code{x} can be a vector, matrix, \code{\link[terra:SpatRaster-class]{SpatRaster}}
or any other \code{R} object for which basic arithmetic operations produce valid results.
These functions are intended to be used in the \code{\link{sim}} function, where \code{x}
is a matrix of the same dimensions as the \code{\link[terra:SpatRaster-class]{SpatRaster}}
object specified in \code{n1_map} parameter.
}
\examples{
x <- 1:10
exponential(x, r = 0.4)

ricker(x, r = 2, K = 5)
ricker(x, r = 2, K = 5, A = -5)

gompertz(x, r = 1.2, K = 5)
gompertz(x, r = 1.2, K = 5, A = 5)

}
\references{
Boukal, D. S., & Berec, L. (2002). Single-species models
of the Allee effect: extinction boundaries, sex ratios and mate encounters.
Journal of Theoretical Biology, 218(3), 375-394.
\doi{10.1006/jtbi.2002.3084}

Gompertz, B. (1825) On the Nature of the Function Expressive of the Law
of Human Mortality, and on a New Mode of Determining the Value of Life
Contigencies. Philosophical Transactions of the Royal Society of London,
115, 513-583. \doi{10.1098/rstl.1825.0026}

Ricker, W.E. (1954) Stock and Recruitment. Journal of the Fisheries
Research Board of Canada, 11, 559-623. \doi{10.1139/f54-039}

Hostetler, J.A. and Chandler, R.B. (2015), Improved state-space models
for inference about spatial and temporal variation in abundance from
count data. Ecology, 96: 1713-1723. \doi{10.1890/14-1487.1}

Courchamp, F., L. Berec and J. Gascoigne. 2008. Allee Effects in Ecology
and Conservation. Oxford University Press, New York. 256 pp. ISBN
978-0-19-857030-1
}
