% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x_from_power_for_x_plot.R
\name{plot.x_from_power}
\alias{plot.x_from_power}
\alias{plot.n_region_from_power}
\title{Plot The Results of 'x_from_power'}
\usage{
\method{plot}{x_from_power}(
  x,
  what = c("ci", "power_curve", "final_x", "final_power", "target_power", switch(x$x, n =
    "sig_area", es = NULL)),
  text_what = c("final_x", "final_power", switch(x$x, n = "sig_area", es = NULL)),
  digits = 3,
  main = paste0("Power Curve ", "(Target Power: ", formatC(x$target_power, digits =
    digits, format = "f"), ")"),
  xlab = NULL,
  ylab = "Estimated Power",
  ci_level = 0.95,
  pars_ci = list(),
  pars_power_curve = list(),
  pars_ci_final_x = list(lwd = 2, length = 0.2, col = "blue"),
  pars_target_power = list(lty = "dashed", lwd = 2, col = "black"),
  pars_final_x = list(lty = "dotted"),
  pars_final_power = list(lty = "dotted", col = "blue"),
  pars_text_final_x = list(y = 0, pos = 3, cex = 1),
  pars_text_final_power = list(pos = 3, cex = 1),
  pars_sig_area = list(col = adjustcolor("lightblue", alpha.f = 0.1)),
  pars_text_sig_area = list(cex = 1),
  ...
)

\method{plot}{n_region_from_power}(
  x,
  what = c("ci", "power_curve", "final_x", "final_power", "target_power", "sig_area"),
  text_what = c("final_x", "final_power", "sig_area"),
  digits = 3,
  main = paste0("Power Curve ", "(Target Power: ", formatC(x$below$target_power, digits =
    digits, format = "f"), ")"),
  xlab = NULL,
  ylab = "Estimated Power",
  ci_level = 0.95,
  pars_ci = list(),
  pars_power_curve = list(),
  pars_ci_final_x = list(lwd = 2, length = 0.2, col = "blue"),
  pars_target_power = list(lty = "dashed", lwd = 2, col = "black"),
  pars_final_x = list(lty = "dotted"),
  pars_final_power = list(lty = "dotted", col = "blue"),
  pars_text_final_x = list(y = 0, pos = 3, cex = 1),
  pars_text_final_power = list(cex = 1),
  pars_sig_area = list(col = adjustcolor("lightblue", alpha.f = 0.1)),
  pars_text_sig_area = list(cex = 1),
  ...
)
}
\arguments{
\item{x}{An \code{x_from_power} object,
the output of \code{\link[=x_from_power]{x_from_power()}}.}

\item{what}{A character vector of
what to include in the
plot. Possible values are
\code{"ci"} (confidence intervals
for the estimated value of the
predictor),
\code{"power_curve"} (the crude power
curve, if available), \code{"final_x"}
(a vertical line for
the value of the predictor with estimated
power close enough to the target
power by confidence interval),
\code{"final_power"} (a horizontal line
for the estimated power of the
final value of the predictor),
\code{"target_power"} (a horizontal
line for the target power),
and \code{"sig_area"} (the area significantly
higher or lower than the target
power, if \code{goal} is \code{"close_enough"}
and \code{what} is \code{"lb"} or \code{"ub"}).
By default, all these elements will
be plotted.}

\item{text_what}{A character vector
of what numbers to be added as
labels. Possible values are
\code{"final_x"} (the value of the
predictor with
estimated power close enough to
the target power by confidence interval)
\code{"final_power"} (the estimated
power of the final value of the
predictor), and
\code{"sig_area"} (labeling the area significantly
higher or lower than the target
power, if \code{goal} is \code{"close_enough"}
and \code{what} is \code{"lb"} or \code{"ub"}).
By default, all these labels will
be added.}

\item{digits}{The number of digits
after the decimal that will be used
when adding numbers.}

\item{main}{The title of the plot.}

\item{xlab, ylab}{The labels for the
horizontal and vertical axes,
respectively.}

\item{ci_level}{The level of
confidence of the confidence intervals,
if requested. Default is \code{.95}, denoting
95\%.}

\item{pars_ci}{A named list of
arguments to be passed to \code{\link[=arrows]{arrows()}}
to customize the drawing of the
confidence intervals.}

\item{pars_power_curve}{A named list of
arguments to be passed to \code{\link[=points]{points()}}
to customize the drawing of the
power curve.}

\item{pars_ci_final_x}{A named list of
arguments to be passed to \code{\link[=arrows]{arrows()}}
to customize the drawing of the
confidence interval of the final
value of the predictor.}

\item{pars_target_power}{A named list
of arguments to be passed to \code{\link[=abline]{abline()}}
when drawing the horizontal line
for the target power.}

\item{pars_final_x}{A
named list of arguments to be passed
to \code{\link[=abline]{abline()}} when drawing the
vertical line for the final value
of the predictor.}

\item{pars_final_power}{A
named list of arguments to be passed
to \code{\link[=abline]{abline()}} when drawing the
horizontal line for the estimated
power at the final value of the
predictor.}

\item{pars_text_final_x}{A
named list of arguments to be passed
to \code{\link[=text]{text()}} when adding the
label for the final value of the
predictor.}

\item{pars_text_final_power}{A
named list of arguments to be passed
to \code{\link[=text]{text()}} when adding the
label for the estimated power
of final value of the predictor.}

\item{pars_sig_area}{A named list
of arguments to be passed to
\code{\link[=rect]{rect()}} when shading the area
significantly higher or lower than
the target power.}

\item{pars_text_sig_area}{A named list
of arguments to be passed to
\code{\link[=text]{text()}} when labelling the area
significantly higher or lower than
the target power.}

\item{...}{Optional arguments.
Passed to \code{\link[=plot]{plot()}} when drawing
the estimated power against the
predictor.}
}
\value{
The \code{plot}-method of \code{x_from_power}
returns \code{x} invisibly.
It is called for its side effect.

The \code{plot}-method of \code{n_region_from_power}
returns \code{x} invisibly.
It is called for its side effect.
}
\description{
It plots the results
of 'x_from_power', such as the
estimated power against sample size.
}
\details{
The \code{plot} method of \code{x_from_power}
objects currently plots the relation
between estimated power and
the values examined by \code{\link[=x_from_power]{x_from_power()}}.
Other elements
can be requested (see the argument
\code{what}), and they can be customized
individually.

The \code{plot}-method for
\code{n_region_from_power} objects is
a modified version of the \code{plot}-method
for \code{x_from_power}. It plots the
results of two runs of \code{\link[=n_from_power]{n_from_power()}}
in one plot. It is otherwise similar
to the \code{plot}-method for \code{x_from_power}.
}
\examples{

# Specify the population model

mod <-
"
m ~ x
y ~ m + x
"

# Specify the population values

mod_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

# Generate the datasets

sim_only <- power4test(nrep = 10,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do a test

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters,
                       test_args = list(pars = "m~x"))

# Determine the sample size with a power of .80 (default)

power_vs_n <- x_from_power(test_out,
                           x = "n",
                           progress = TRUE,
                           target_power = .80,
                           final_nrep = 10,
                           max_trials = 1,
                           seed = 2345)
plot(power_vs_n)

}
\seealso{
\code{\link[=x_from_power]{x_from_power()}}
}
