% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransitiveClosure.R
\name{TransitiveClosure}
\alias{TransitiveClosure}
\title{Computing transitive closure.}
\usage{
TransitiveClosure(rel)
}
\arguments{
\item{rel}{A two-columns character matrix, each row comprising an element (pair) of the binary relation.}
}
\value{
A transitive binary relation, as a two-columns character matrix (each row comprises an element (pair)
of the transitivity closed relation).
}
\description{
Computes the transitive closure of the input binary relation.
}
\examples{
rel <- matrix(c(
  "a", "b",
  "c", "b",
  "d", "a",
  "c", "a",
  "a", "a",
  "b", "b",
  "c", "c",
  "d", "d"
), ncol = 2, byrow = TRUE)

t.clo<-TransitiveClosure(rel)

}
