% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{summary_modelSelect}
\alias{summary_modelSelect}
\title{Posterior model probabilities}
\usage{
summary_modelSelect(object, print = TRUE)
}
\arguments{
\item{object}{a list created by the \code{\link[=modelSelect]{modelSelect()}} function, containing
results of model selection with Approximate Bayesian Computation.}

\item{print}{logical, if TRUE (default), then this function prints the mean
models probabilities.}
}
\value{
a list with two main elements if model selection used the regression
algorithm or a single element if only the rejection step was used:

\item{rejection}{results of model selection based on the rejection method.
This element contains two entries, the first is an object of class numeric
with the posterior model probabilities and the second are the Bayes factors
between pairs of models.}

\item{mnlogistic}{results of model selection based on the regression
method. This element contains two entries, the first is an object of class
numeric with the posterior model probabilities and the second are the Bayes
factors between pairs of models.}
}
\description{
Extract the posterior model probabilities and obtain a summary of model
selection performed with Approximate Bayesian Computation.
}
\details{
This function produces an easy-to-read output of the model selection step. It
also computes the Bayes factors.
}
\examples{
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# create a "fake" vector of model indices
# this assumes that half the simulations were from one model and the other half from other model
# this is not true but serves as an example of how to use this function
index <- c(rep("model1", nrow(sumstats)/2), rep("model2", nrow(sumstats)/2))

# perform model selection with ABC
mysel <- modelSelect(target = target, index = index, sumstats = sumstats,
tol = 0.01, method = "regression")

# compute posterior model probabilities
summary_modelSelect(object = mysel)

}
