% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{sim_modelSel}
\alias{sim_modelSel}
\title{Leave-one-out cross validation of model selection}
\usage{
sim_modelSel(index, sumstats, nval, tol, warning = FALSE)
}
\arguments{
\item{index}{is a vector of model indices. This can be a a character vector
of model names, repeated as many times as there are simulations for each
model. This vector will be coerced to factor and it must have the same
length as \code{nrow(sumstats)} to indicate which row of the \code{sumstats}
matrix belongs to which model.}

\item{sumstats}{is a vector or matrix containing the simulated summary
statistics for all the models. Each row or vector entry should be a
different simulation and each column of a matrix should be a different
statistic. The order must be the same as the order of the models in the
\code{index} vector.}

\item{nval}{a numerical value defining the the size of the cross-validation
sample for each model.}

\item{tol}{is a numerical value, indicating the required proportion of points
nearest the target values (tolerance).}

\item{warning}{logical, if FALSE (default) warnings produced while running
this function, mainly related with accepting simulations for just one of
the models, will not be displayed.}
}
\value{
a list with the following elements:

\item{cvsamples}{is a vector of length \code{nval*the number of models}
indicating which rows of the \code{sumstat} input were used as validation values
for each model.}

\item{true}{a character vector of the true models.}

\item{estimated}{a character vector of the estimated models.}

\item{model.probs}{a matrix with the estimated model probabilities. Each
row of the matrix represents a different cross-validation trial.}

\item{models}{a character vector with the designation of the models.}
}
\description{
This function performs a simulation study to assess the quality of model
selection with ABC. This is done by performing a leave-one-out cross
validation via subsequent calls to the function \code{\link[=modelSelect]{modelSelect()}}.
}
\details{
One simulation is randomly selected from each model to be a validation
simulation, while all the other simulations are used as training simulations.
This random simulation is used as the target of the \code{\link[=modelSelect]{modelSelect()}} function
and posterior model probabilities are estimated.

Please note that the actual size of the cross-validation sample is
\code{nval*the number of models}. This is because \code{nval} cross-validation
estimation steps are performed for each model.
}
\examples{
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# create a "fake" vector of model indices
# this assumes that half the simulations were from one model and the other half from other model
# this is not true but serves as an example of how to use this function
index <- c(rep("model1", nrow(sumstats)/2), rep("model2", nrow(sumstats)/2))

# perform a leave-one-out cross validation of model selection
sim_modelSel(index = index, sumstats = sumstats, nval = 10, tol = 0.1)

}
