% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_copula_pbox.R
\docType{methods}
\name{fit_copula_pbox}
\alias{fit_copula_pbox}
\alias{fit_copula_pbox,ANY-method}
\title{Fit Copula Models to Data}
\usage{
fit_copula_pbox(data, .copula_families)

\S4method{fit_copula_pbox}{ANY}(data, .copula_families)
}
\arguments{
\item{data}{A data frame or data table; the data will be coerced to a `data.table` internally.}

\item{.copula_families}{A list specifying copula families to evaluate.
The list should be structured with names corresponding to the type of copula
(e.g., 'archmCopula', 'evCopula', 'ellipCopula') and elements being vectors
of strings naming the copula families (e.g., "clayton", "frank").}
}
\value{
A data table summarizing the AIC and parameter estimates for each copula family evaluated.
}
\description{
Automatically fits various copula models specified in a list to the provided data.
This function is a wrapper around the underlying copula fitting function, facilitating
the exploration of multiple copula families to identify the best fitting model based
on criteria such as AIC.

`fit_copula_pbox` method to fit a variety of copula models to data.
This method performs a grid search over specified copula families to find the best fit.
It employs the pseudoinverse of the empirical distribution functions to standardize the data.
}
\examples{
  data("SEAex")
  .copula_families <- list(
    archmCopula = c("clayton", "frank", "gumbel", "joe"),
    evCopula = c("galambos", "gumbel", "huslerReiss"),
    ellipCopula = c("normal")
  )
  distFits <- fit_copula_pbox(data = SEAex, .copula_families)
  print(distFits)
}
