% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_KEGG_diagram}
\alias{visualize_KEGG_diagram}
\title{Visualize Human KEGG Pathways}
\usage{
visualize_KEGG_diagram(
  kegg_pw_ids,
  input_processed,
  scale_vals = TRUE,
  node_cols = NULL,
  legend.position = "top"
)
}
\arguments{
\item{kegg_pw_ids}{KEGG ids of pathways to be colored and visualized}

\item{input_processed}{input data processed via \code{\link{input_processing}}}

\item{scale_vals}{should change values be scaled? (default = \code{TRUE})}

\item{node_cols}{low, middle and high color values for coloring the pathway nodes
(default = \code{NULL}). If \code{node_cols=NULL}, the low, middle and high color
are set as 'green', 'gray' and 'red'. If all change values are 1e6 (in case no
changes are supplied, this dummy value is assigned by
\code{\link{input_processing}}), only one color ('#F38F18' if NULL) is used.}

\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}
}
\value{
Creates colored visualizations of the enriched human KEGG pathways
and returns them as a list of ggplot objects, named by Term ID.
}
\description{
Visualize Human KEGG Pathways
}
\examples{
\dontrun{
input_processed <- data.frame(
  GENE = c("PKLR", "GPI", "CREB1", "INS"),
  CHANGE = c(1.5, -2, 3, 5)
)
gg_list <- visualize_KEGG_diagram(c("hsa00010", "hsa04911"), input_processed)
}
}
\seealso{
See \code{\link{visualize_terms}} for the wrapper function for
creating enriched term diagrams. See \code{\link{run_pathfindR}} for the
wrapper function of the pathfindR enrichment workflow.
}
