% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_access}
\alias{dsadmin.profile_access}
\title{Restrict or open access to a DataSHIELD profile}
\usage{
dsadmin.profile_access(opal, name, restricted = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the profile.}

\item{restricted}{Default value is TRUE.}
}
\description{
When access is restricted, only users (or group of users) with this profile use permissions
will be allowed to use this profile. When access is not restricted, all
DataSHIELD users are allowed to use this profile. See also \link{dsadmin.profile_perm}.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_create(o, name = 'survival', cluster = 'demo')
dsadmin.profile_access(o, name = 'survival', restricted = TRUE)
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()}
}
\concept{DataSHIELD profiles}
