% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{numberRecords}
\alias{numberRecords}
\title{Count the number of records that a \code{cdm_table} has.}
\usage{
numberRecords(x)
}
\arguments{
\item{x}{A cdm_table.}
}
\value{
An integer with the number of records in the table.
}
\description{
Count the number of records that a \code{cdm_table} has.
}
\examples{
person <- dplyr::tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- dplyr::tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2023-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test"
)

numberRecords(cdm$observation_period)

}
