% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_speleothem.R
\name{set_speleothem}
\alias{set_speleothem}
\title{Set Speleothem}
\usage{
set_speleothem(
  x = NA,
  entityid = NA_integer_,
  entityname = NA_character_,
  siteid = NA_integer_,
  collectionunitid = NA_integer_,
  dripheight = NA_integer_,
  monitoring = FALSE,
  geology = NA_character_,
  relativeage = NA_character_,
  speleothemtype = NA_character_,
  dripheightunits = NA_character_,
  entitycovertype = NA_character_,
  entrancedistance = NA_integer_,
  landusecovertype = NA_character_,
  speleothemdriptype = NA_character_,
  landusecoverpercent = NA_integer_,
  vegetationcovertype = NA_character_,
  entitycoverthickness = NA_integer_,
  entrancedistanceunits = NA_character_,
  vegetationcoverpercent = NA_integer_
)
}
\arguments{
\item{x}{Object to be set as a speleothem}

\item{entityid}{The speleothem entity ID.}

\item{entityname}{Name of the speleothem entity.}

\item{siteid}{The unique site ID for a site.}

\item{collectionunitid}{The unique collection unit ID for a collection unit.}

\item{dripheight}{drip height}

\item{monitoring}{Is the speleothem being monitored? TRUE/FALSE}

\item{geology}{rock type of the speleothem}

\item{relativeage}{relative age of the speleothem}

\item{speleothemtype}{type of speleothem}

\item{dripheightunits}{Units for drip height}

\item{entitycovertype}{type of cover around the speleothem}

\item{entrancedistance}{distance from cave entrance}

\item{landusecovertype}{type of land use cover around the speleothem}

\item{speleothemdriptype}{type of speleothem drip}

\item{landusecoverpercent}{land use cover percent}

\item{vegetationcovertype}{type of vegetation cover around the speleothem}

\item{entitycoverthickness}{thickness of the entity cover}

\item{entrancedistanceunits}{Units for distance from cave entrance}

\item{vegetationcoverpercent}{vegetation cover percent}
}
\value{
\code{speleothem} object
}
\description{
Set Speleothem
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
