% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tsce}
\alias{tsce}
\title{Exact solution of the Two-Stage Clonal Expansion Model}
\usage{
tsce(t, parameterList)
}
\arguments{
\item{t}{Each element in a row of \code{t} defines the endpoint of a
time interval.
The first time interval starts at time \code{0}.
The last element is the time point for which hazard and survival
function are evaluated.
Elements in a row have to be in monotonously increasing order.
In order to achieve a different number of time intervals for
different rows, rows may start with an arbitrary number of zeros
(i.e. time intervals of length zero).}

\item{parameterList}{List of Matrices.
Each list member has to be named. Allowed names are \code{Nnu0},
\code{alpha}, \code{gamma}, and \code{nu1}.
Matrices \code{Nnu0} and \code{nu1} must be provided.
If \code{alpha} or \code{gamma} are missing,
they are assumed to be zero.
For each matrix it has to hold that the number of columns 
must be equal to the ones in \code{t}.
The number of rows can either equal to the number of rows in
\code{t}, or only one row is provided,
which then is applied to all rows of \code{t}.

Values in matrices \code{Nnu0}, \code{alpha}, \code{gamma},
\code{nu1} correspond to parameters for each time interval,
see the figure and explanations in the package vignette.
Here, \code{Nnu0} is the product of \eqn{N}{N} and \eqn{\nu_0}{nu0}
and \eqn{\gamma}{gamma} is defined by
\eqn{\alpha-\beta}{alpha-beta}.}
}
\description{
For piecewise constant parameters \code{tsce(t,parameterList)}
returns the exact hazard and logarithm of the survival function
of the Two-Stage Clonal Expansion Model.
All arguments are matrices.
Evaluation is performed separately for each row.
}
\details{
\figure{TSCE.jpg}{Schematic depiction of the TSCE model.
        See the package vignette for details.}
}
\examples{
t <-matrix(data=c(10,20,65,10,20,70),nrow=2,byrow=TRUE)
Nnu0 <- matrix(c(0.3,0.7,1),nrow = 1)
alpha<- matrix(1,nrow=1,ncol=3)
gamma<- matrix(c(0.13,0.13,0.13, 0.15,0.15,0.15),nrow=2,byrow=TRUE)
nu1  <- matrix(1e-6,nrow=1,ncol=3)
pars = list(Nnu0=Nnu0, alpha=alpha,gamma=gamma,nu1=nu1) 

tsce(t,pars)
}
\seealso{
\code{\link{msce_numerical}}
}
