% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_standardized.R
\name{mlts_standardized}
\alias{mlts_standardized}
\title{Get Standardized Estimates for an mlts Model}
\usage{
mlts_standardized(
  object,
  what = c("between", "within", "both"),
  digits = 3,
  prob = 0.95,
  add_cluster_std = FALSE
)
}
\arguments{
\item{object}{\code{mltsfit}. Output of \code{\link[mlts]{mlts_model}} and related functions.}

\item{what}{character. Get between-level standardized estimates (\code{what = "between"}, the default),
within-level standardized estimates averaged over clusters (\code{what = "within"}), or both (\code{what = "both"}).}

\item{digits}{Number of digits. Default is 3.}

\item{prob}{A value between 0 and 1 to indicate the width of the credible
interval. Default is .95.}

\item{add_cluster_std}{logical. If \code{what = "within"}, within-level standardized effects for each cluster
are included in the output (defaults to \code{FALSE}).}
}
\value{
A \code{list} containing between- and within-level standardized parameters.
}
\description{
Get Standardized Estimates for an mlts Model
}
\examples{
\donttest{
# build simple vector-autoregressive mlts model for two time-series variables
var_model <- mlts_model(q = 2)

# fit model with (artificial) dataset ts_data
fit <- mlts_fit(
  model = var_model,
  data = ts_data,
  ts = c("Y1", "Y2"), # time-series variables
  id = "ID", # identifier variable
  time = "time", # time variable
  tinterval = 1, # interval for approximation of continuous-time dynamic model,
  monitor_person_pars = TRUE # person parameters need to be sampled for standardization
)

# inspect standardized parameter estimates
mlts_standardized(fit)
}

}
