% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutputTrafo.R
\name{OutputTrafo}
\alias{OutputTrafo}
\title{Output Transformation Base Class}
\description{
Abstract output transformation class.

An output transformation can be used within a \link{Surrogate} to perform a transformation of the target variable(s).
}
\seealso{
Other Output Transformation: 
\code{\link{OutputTrafoLog}},
\code{\link{OutputTrafoStandardize}},
\code{\link{mlr_output_trafos}}
}
\concept{Output Transformation}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{label}}{(\code{character(1)})\cr
Label for this object.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{state}}{(named \code{list()} | \code{NULL})\cr
List of meta information regarding the parameters and their state.}

\item{\code{cols_y}}{(\code{character()} | \code{NULL})\cr
Column ids of target variables that should be transformed.}

\item{\code{max_to_min}}{(\code{-1} | \code{1})\cr
Multiplicative factor to correct for minimization or maximization.}

\item{\code{invert_posterior}}{(\code{logical(1)})\cr
Should the posterior predictive distribution be inverted when used within a \link{SurrogateLearner} or \link{SurrogateLearnerCollection}?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OutputTrafo-new}{\code{OutputTrafo$new()}}
\item \href{#method-OutputTrafo-update}{\code{OutputTrafo$update()}}
\item \href{#method-OutputTrafo-transform}{\code{OutputTrafo$transform()}}
\item \href{#method-OutputTrafo-inverse_transform_posterior}{\code{OutputTrafo$inverse_transform_posterior()}}
\item \href{#method-OutputTrafo-inverse_transform}{\code{OutputTrafo$inverse_transform()}}
\item \href{#method-OutputTrafo-format}{\code{OutputTrafo$format()}}
\item \href{#method-OutputTrafo-print}{\code{OutputTrafo$print()}}
\item \href{#method-OutputTrafo-clone}{\code{OutputTrafo$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-new"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$new(invert_posterior, label = NA_character_, man = NA_character_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{invert_posterior}}{(\code{logical(1)})\cr
Should the posterior predictive distribution be inverted when used within a \link{SurrogateLearner} or \link{SurrogateLearnerCollection}?}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-update"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-update}{}}}
\subsection{Method \code{update()}}{
Learn the transformation based on observed data and update parameters in \verb{$state}.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$update(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-transform}{}}}
\subsection{Method \code{transform()}}{
Perform the transformation.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-inverse_transform_posterior"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-inverse_transform_posterior}{}}}
\subsection{Method \code{inverse_transform_posterior()}}{
Perform the inverse transformation on a posterior predictive distribution characterized by the first and second moment.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$inverse_transform_posterior(pred)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pred}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation characterizing a posterior predictive distribution with the columns \code{mean} and \code{se}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \code{mean} and \code{se}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-inverse_transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-inverse_transform}{}}}
\subsection{Method \code{inverse_transform()}}{
Perform the inverse transformation.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$inverse_transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-format"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$format()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character(1)}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-print"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
