% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metarep.R
\name{metarep}
\alias{metarep}
\title{Replicability-analysis of a meta-analysis}
\usage{
metarep(
  x,
  u = 2,
  t = 0.05,
  alternative = "two-sided",
  report.u.max = FALSE,
  confidence = 0.95,
  common.effect = FALSE
)
}
\arguments{
\item{x}{object of class 'meta'}

\item{u}{replicability requirement. \code{u} must be an intiger between 2 and \code{n} (nmber of studies in the meta-analysis).}

\item{t}{truncation threshold for truncated-Pearsons' test (`t=0.05` by default). t is ignored if `common.effect  = TRUE`.}

\item{alternative}{use 'less', 'greater' or 'two-sided'}

\item{report.u.max}{use TREU to report the lower bounds on number of studies with replicated effect.}

\item{confidence}{Confidence level used in the computaion of the lower bound(s) \eqn{u_{max}^L} and\\or \eqn{u_{max}^R}.}

\item{common.effect}{Use common.effect = FALSE (default) for replicability-analysis combining with no assumptions (Pearson or truncated-Pearson test).
Replicability-analysis based on the test-statistic of common-effects model can be applied using common.effect = TRUE.}
}
\value{
An object of class list containing meta-analysis and replicability analysis results, as follows:
\item{worst.case.studies}{A charachter vector of the names of \code{n-u+1} studies at which the the \code{r(u)-}value is computed.}
\item{r.value}{ \code{r(u)-}value for the specied u. }
\item{side}{The direction of the effect with the lower one-sided \code{r(u)-}value }
\item{u_L , u_R }{ Lower bounds of the number of studies with decreased or increased effect, respectively. Both bounds are reported simultinualsly only when performing replicability analysis for two-sided alternative with no assumptions  }
}
\description{
Add results of replicability-analysis to a meta-analysis, whether common- or random-effects.
}
\examples{
 n.i.1 <- c( 20, 208, 24, 190, 58, 36, 51)
a.i <- c( 2,79,0,98,15,34,9) 
n.i.2 <- c( 20, 119, 22, 185, 29, 51, 47)
c.i <- c(9,106,14,98,12,49,9) 
m1 <- metabin( event.e = a.i,n.e = n.i.1,event.c = c.i,n.c = n.i.2,
               studlab = paste0('Study ' , 1:7) , sm = 'OR' ,
               common = FALSE, random = TRUE )
mr1 <- metarep(  m1 , u = 2, common.effect = FALSE , t = 0.05 , 
               alternative = 'two-sided', report.u.max = TRUE)
forest(mr1, layout='revman5',digits.pval = 4 , test.overall = TRUE )
}
