% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{historicalize3}
\alias{historicalize3}
\title{Create Historical Vertical Data Frame from Ahistorical Vertical Data Frame}
\usage{
historicalize3(
  data,
  popidcol = 0,
  patchidcol = 0,
  individcol,
  year2col = 0,
  year3col = 0,
  xcol = 0,
  ycol = 0,
  sizea2col = 0,
  sizea3col = 0,
  sizeb2col = 0,
  sizeb3col = 0,
  sizec2col = 0,
  sizec3col = 0,
  repstra2col = 0,
  repstra3col = 0,
  repstrb2col = 0,
  repstrb3col = 0,
  feca2col = 0,
  feca3col = 0,
  fecb2col = 0,
  fecb3col = 0,
  indcova2col = 0,
  indcova3col = 0,
  indcovb2col = 0,
  indcovb3col = 0,
  indcovc2col = 0,
  indcovc3col = 0,
  alive2col = 0,
  alive3col = 0,
  dead2col = 0,
  dead3col = 0,
  obs2col = 0,
  obs3col = 0,
  nonobs2col = 0,
  nonobs3col = 0,
  repstrrel = 1,
  fecrel = 1,
  stage2col = 0,
  stage3col = 0,
  juv2col = 0,
  juv3col = 0,
  stageassign = NA,
  stagesize = NA,
  censor = FALSE,
  censorcol = 0,
  censorkeep = 0,
  spacing = NA,
  NAas0 = FALSE,
  NRasRep = FALSE,
  NOasObs = FALSE,
  prebreeding = TRUE,
  age_offset = 0,
  reduce = TRUE,
  a2check = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{data}{The horizontal data file.}

\item{popidcol}{A variable name or column number corresponding to the
identity of the population for each individual.}

\item{patchidcol}{A variable name or column number corresponding to the
identity of the patch or subpopulation for each individual, if patches have
been designated within populations.}

\item{individcol}{A variable name or column number corresponding to the
unique identity of each individual.}

\item{year2col}{A variable name or column number corresponding to occasion
\emph{t} (year or time).}

\item{year3col}{A variable name or column number corresponding to occasion
\emph{t}+1 (year or time).}

\item{xcol}{A variable name or column number corresponding to the X
coordinate of each individual in Cartesian space.}

\item{ycol}{A variable name or column number corresponding to the Y
coordinate of each individual in Cartesian space.}

\item{sizea2col}{A variable name or column number corresponding to the
primary size entry in occasion \emph{t}.}

\item{sizea3col}{A variable name or column number corresponding to the
primary size entry in occasion \emph{t}+1.}

\item{sizeb2col}{A variable name or column number corresponding to the
secondary size entry in occasion \emph{t}.}

\item{sizeb3col}{A variable name or column number corresponding to the
secondary size entry in occasion \emph{t}+1.}

\item{sizec2col}{A variable name or column number corresponding to the
tertiary size entry in occasion \emph{t}.}

\item{sizec3col}{A variable name or column number corresponding to the
tertiary size entry in occasion \emph{t}+1.}

\item{repstra2col}{A variable name or column number corresponding to the
production of reproductive structures, such as flowers, in occasion \emph{t}.
This can be binomial or count data, and is used to in analysis of the
probability of reproduction.}

\item{repstra3col}{A variable name or column number corresponding to the
production of reproductive structures, such as flowers, in occasion
\emph{t}+1. This can be binomial or count data, and is used to in analysis
of the probability of reproduction.}

\item{repstrb2col}{A second variable name or column number corresponding to
the production of reproductive structures, such as flowers, in occasion
\emph{t}. This can be binomial or count data.}

\item{repstrb3col}{A second variable name or column number corresponding to
the production of reproductive structures, such as flowers, in occasion 
\emph{t}+1. This can be binomial or count data.}

\item{feca2col}{A variable name or column number corresponding to fecundity
in occasion \emph{t}. This may represent egg counts, fruit counts, seed 
production, etc.}

\item{feca3col}{A variable name or column number corresponding to fecundity
in occasion \emph{t}+1. This may represent egg counts, fruit counts, seed
production, etc.}

\item{fecb2col}{A second variable name or column number corresponding to 
fecundity in occasion \emph{t}. This may represent egg counts, fruit counts,
seed production, etc.}

\item{fecb3col}{A second variable name or column number corresponding to 
fecundity in occasion \emph{t}+1. This may represent egg counts, fruit
counts, seed production, etc.}

\item{indcova2col}{A variable name or column number corresponding to an
individual covariate to be used in analysis, in occasion \emph{t}.}

\item{indcova3col}{A variable name or column number corresponding to an
individual covariate to be used in analysis, in occasion \emph{t}+1.}

\item{indcovb2col}{A variable name or column number corresponding to a second
individual covariate to be used in analysis, in occasion \emph{t}.}

\item{indcovb3col}{A variable name or column number corresponding to a second
individual covariate to be used in analysis, in occasion \emph{t}+1.}

\item{indcovc2col}{A variable name or column number corresponding to a third
individual covariate to be used in analysis, in occasion \emph{t}.}

\item{indcovc3col}{A variable name or column number corresponding to a third
individual covariate to be used in analysis, in occasion \emph{t}+1.}

\item{alive2col}{A variable name or column number that provides information
on whether an individual is alive in occasion \emph{t}. If used, living
status must be designated as binomial (living = \code{1}, dead = \code{0}).}

\item{alive3col}{A variable name or column number that provides information
on whether an individual is alive in occasion \emph{t}+1. If used, living
status must be designated as binomial (living = \code{1}, dead = \code{0}).}

\item{dead2col}{A variable name or column number that provides information on
whether an individual is dead in occasion \emph{t}. If used, dead status
must be designated as binomial (living = \code{0}, dead = \code{1}).}

\item{dead3col}{A variable name or column number that provides information on
whether an individual is dead in occasion \emph{t}+1. If used, dead status
must be designated as binomial (living = \code{0}, dead = \code{1}).}

\item{obs2col}{A variable name or column number providing information on
whether an individual is in an observable stage in occasion \emph{t}. If
used, observation status must be designated as binomial (observed = \code{1},
not observed = \code{0}).}

\item{obs3col}{A variable name or column number providing information on
whether an individual is in an observable stage in occasion \emph{t}+1. If
used, observation status must be designated as binomial (observed = \code{1},
not observed = \code{0}).}

\item{nonobs2col}{A variable name or column number providing information on
whether an individual is in an unobservable stage in occasion \emph{t}. If
used, observation status must be designated as binomial (observed = \code{0},
not observed = \code{1}).}

\item{nonobs3col}{A variable name or column number providing information on
whether an individual is in an unobservable stage in occasion \emph{t}+1. If
used, observation status must be designated as binomial (observed = \code{0},
not observed = \code{1}).}

\item{repstrrel}{This is a scalar multiplier making the variable represented
by \code{repstrb2col} equivalent to the variable represented by 
\code{repstra2col}. This can be useful if two reproductive status variables
have related but unequal units, for example if \code{repstrb2col} refers to
one-flowered stems while \code{repstra2col} refers to two-flowered stems.}

\item{fecrel}{This is a scalar multiplier making the variable represented by
\code{fecb2col} equivalent to the variable represented by \code{feca2col}.
This can be useful if two fecundity variables have related but unequal units.}

\item{stage2col}{Optional variable name or column number corresponding to
life history stage in occasion \emph{t}.}

\item{stage3col}{Optional variable name or column number corresponding to
life history stage in occasion \emph{t}+1.}

\item{juv2col}{A variable name or column number that marks individuals in
immature stages in occasion \emph{t}. Function \code{historicalize3()}
assumes that immature individuals are identified in this variable marked with
a number equal to or greater than \code{1}, and that mature individuals are
marked as \code{0} or \code{NA}.}

\item{juv3col}{A variable name or column number that marks individuals in
immature stages in occasion \emph{t}+1. Function \code{historicalize3()}
assumes that immature individuals are identified in this variable marked with
a number equal to or greater than \code{1}, and that mature individuals are
marked as \code{0} or \code{NA}.}

\item{stageassign}{The stageframe object identifying the life history model
being operationalized. Note that if \code{stage2col} is provided, then this
stageframe is not utilized in stage designation.}

\item{stagesize}{A variable name or column number describing which size 
variable to use in stage estimation. Defaults to \code{NA}, and can also take 
\code{sizea}, \code{sizeb}, \code{sizec}, \code{sizeab}, \code{sizebc},
\code{sizeac}, \code{sizeabc}, or \code{sizeadded}, depending on
which size variable within the input dataset is chosen. Note that the
variable(s) chosen should be presented in the order of the primary,
secondary, and tertiary variables in the stageframe input with
\code{stageassign}. For example, choosing \code{sizeb} assumes that this size
variable in the dataset is the primary variable in the stageframe.}

\item{censor}{A logical variable determining whether the output data should
be censored using the variable defined in \code{censorcol}. Defaults to 
\code{FALSE}.}

\item{censorcol}{A variable name or column number corresponding to a censor
variable within the dataset, used to distinguish between entries to use and
those to discard from analysis, or to designate entries with special issues 
that require further attention.}

\item{censorkeep}{The value of the censoring variable identifying data that
should be included in analysis. Defaults to \code{0}, but may take any value
including \code{NA}.}

\item{spacing}{The spacing at which density should be estimated, if density
estimation is desired and X and Y coordinates are supplied. Given in the same
units as those used in the X and Y coordinates given in \code{xcol} and
\code{ycol}. Defaults to \code{NA}.}

\item{NAas0}{If TRUE, then all \code{NA} entries for size and fecundity
variables will be set to \code{0}. This can help increase the sample size
analyzed by  \code{\link{modelsearch}()}, but should only be used when it is
clear that this substitution is biologically realistic. Defaults to
\code{FALSE}.}

\item{NRasRep}{If set to \code{TRUE}, then this function will treat
non-reproductive but mature individuals as reproductive during stage
assignment. This can be useful when a matrix is desired without separation of
reproductive and non-reproductive but mature stages of the same size. Only
used if \code{stageassign} is set to a valid stageframe. Defaults to
\code{FALSE}.}

\item{NOasObs}{If \code{TRUE}, then will treat individuals that are
interpreted as not observed in the dataset as though they were observed
during stage assignment. This can be useful when a MPM is desired without
separation of observable and unobservable stages. Only used if
\code{stageassign} is set to a stageframe. Defaults to \code{FALSE}.}

\item{prebreeding}{A logical term indicating whether the life history model
is pre-breeding. If so, then \code{1} is added to all ages. Defaults to
\code{TRUE}.}

\item{age_offset}{A number to add automatically to all values of age at time
\emph{t}. Defaults to \code{0}.}

\item{reduce}{A logical variable determining whether unused variables and
some invariant state variables should be removed from the output dataset.
Defaults to \code{TRUE}.}

\item{a2check}{A logical variable indicating whether to retain all data with
living status at occasion \emph{t}. Defaults to \code{FALSE}, in which case
data for occasions in which the individual is not alive in time \emph{t} is
not retained. This option should be kept \code{FALSE}, except to inspect
potential errors in the dataset.}

\item{quiet}{A logical variable indicating whether to silence warnings.
Defaults to \code{FALSE}.}
}
\value{
If all inputs are properly formatted, then this function will output
a historical vertical data frame (class \code{hfvdata}), meaning that the
output data frame will have three consecutive years of size and reproductive
data per individual per row. This data frame is in standard format for all
functions used in \code{lefko3}, and so can be used without further 
modification. Note that determination of state in occasions \emph{t}-1 and
\emph{t}+1 gives preference to condition in occasion \emph{t} within the
input dataset. Conflicts in condition in input datasets that have both
occasions \emph{t} and \emph{t}+1 listed per row are resolved by using
condition in occasion \emph{t}.

Variables in this data frame include the following:
\item{rowid}{Unique identifier for the row of the data frame.}
\item{popid}{Unique identifier for the population, if given.}
\item{patchid}{Unique identifier for patch within population, if given.}
\item{individ}{Unique identifier for the individual.}
\item{year2}{Year or time in occasion \emph{t}.}
\item{firstseen}{Occasion of first observation.}
\item{lastseen}{Occasion of last observation.}
\item{obsage}{Observed age in occasion \emph{t}, assuming first observation
corresponds to age = 0.}
\item{obslifespan}{Observed lifespan, given as \code{lastseen - firstseen + 1}.}
\item{xpos1,xpos2,xpos3}{X position in Cartesian space in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively, if provided.}
\item{ypos1,ypos2,ypos3}{Y position in Cartesian space in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively, if provided.}
\item{sizea1,sizea2,sizea3}{Main size measurement in occasions \emph{t}-1,
\emph{t}, and \emph{t}+1, respectively.}
\item{sizeb1,sizeb2,sizeb3}{Secondary size measurement in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{sizec1,sizec2,sizec3}{Tertiary size measurement in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{size1added,size2added,size3added}{Sum of primary, secondary, and
tertiary size measurements in occasions \emph{t}-1, \emph{t}, and \emph{t}+1,
respectively.}
\item{repstra1,repstra2,repstra3}{Main numbers of reproductive structures in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstrb1,repstrb2,repstrb3}{Secondary numbers of reproductive
structures in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstr1added,repstr2added,repstr3added}{Sum of primary and secondary
reproductive structures in occasions \emph{t}-1, \emph{t}, and \emph{t}+1,
respectively.}
\item{feca1,feca2,feca3}{Main numbers of offspring in occasions \emph{t}-1,
\emph{t}, and \emph{t}+1, respectively.}
\item{fecb1,fecb2, fecb3}{Secondary numbers of offspring in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fec1added,fec2added,fec3added}{Sum of primary and secondary fecundity
in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{censor1,censor2,censor3}{Censor status values in occasions \emph{t}-1,
\emph{t}, and \emph{t}+1, respectively.}
\item{juvgiven1,juvgiven2,juvgiven3}{Binomial variable indicating whether
individual is juvenile in occasions \emph{t}-1, \emph{t}, and \emph{t}+1.
Only given if \code{juvcol} is provided.}
\item{obsstatus1,obsstatus2,obsstatus3}{Binomial observation status in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstatus1,repstatus2,repstatus3}{Binomial reproductive status in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fecstatus1,fecstatus2,fecstatus3}{Binomial offspring production status
in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{matstatus1,matstatus2,matstatus3}{Binomial maturity status in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{alive1,alive2,alive3}{Binomial status as alive in occasions \emph{t}-1,
 \emph{t}, and \emph{t}+1, respectively.}
\item{density}{Density of individuals per unit designated in \code{spacing}.
Only given if spacing is not \code{NA}.}
}
\description{
Function \code{historicalize3()} returns a vertically formatted demographic
data frame organized to create historical projection matrices, given a
vertically but ahistorically formatted data frame. This data frame is in
standard \code{hfvdata} format and can be used in all functions in the
package.
}
\section{Notes}{

Warnings that some individuals occur in state combinations that do not match
any stages in the stageframe used to assign stages, and that some individuals
match characteristics of several stages in the stageframe, are common when
first working with a dataset. Typically, these situations can be identified as
\code{NoMatch} entries in \code{stage3}, although such entries may crop up in
\code{stage1} and \code{stage2}, as well. In some cases, these warnings will
arise with no concurrent \code{NoMatch} entries. These are important warnings
and suggest that there is likely a problem with the stageframe. The most
common such problems are: 1) stages have significant overlap in
characteristics, with the most common being overlapping size bins caused by
erroneous definitions of size bin halfwidths; and 2) some individuals exist
in states not defined within the stageframe.

In some datasets with unobservable stages, observation status
(\code{obsstatus}) might not be inferred properly if a single size variable
is used that does not yield sizes greater than 0 in all cases in which
individuals were observed. Such situations may arise, for example, in plants
when leaf number is the dominant size variable used, but individuals
occasionally occur with inflorescences but no leaves. In this instances,
it helps to mark related variables as \code{sizeb} and \code{sizec}, because
observation status will be interpreted in relation to all 3 size variables.
Alternatively, observation status may be input via \code{obs2col} and
\code{obs3col} to force computation with given values (although this requires
all instances of observation and non-observation to be known and coded ahead
of time). Further analysis can then utilize only a single size variable, of
the user's choosing. Similar issues can arise in reproductive status
(\code{repstatus}).

Juvenile designation should only be used when juveniles fall outside of the
size classification scheme used in determining stages. If juveniles are to be
size classified along the size spectrum that adults also fall on, then
it is best to treat juveniles as mature but not reproductive.

Care should be taken to avoid variables with negative values indicating size,
fecundity, or reproductive or observation status. Negative values can be
interpreted in different ways, typically reflecting estimation through other
algorithms rather than actual measured data. Variables holding negative
values can conflict with data management algorithms in ways that are
difficult to predict.

Unusual errors (e.g. \code{"Error in pjf..."}) may occur in cases where the
variables are improperly passed, or where seemingly numeric variables include
text and so get automatically converted to string variables.

Density estimation is performed as a count of individuals alive and within
the radius specified in \code{spacing} of the respective individual at some
point in time.
}

\examples{
data(cypvert)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v2 <- historicalize3(data = cypvert, patchidcol = "patch", 
  individcol = "plantid", year2col = "year2", sizea2col = "Inf2.2", 
  sizea3col = "Inf2.3", sizeb2col = "Inf.2", sizeb3col = "Inf.3", 
  sizec2col = "Veg.2", sizec3col = "Veg.3", repstra2col = "Inf2.2", 
  repstra3col = "Inf2.3", repstrb2col = "Inf.2", repstrb3col = "Inf.3", 
  feca2col = "Pod.2", feca3col = "Pod.3", repstrrel = 2, 
  stageassign = cypframe_raw, stagesize = "sizeadded", censorcol = "censor",
  censor = FALSE, NAas0 = TRUE, NRasRep = TRUE, reduce = TRUE)

}
