% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_functions.R
\name{cond_rm_facets}
\alias{cond_rm_facets}
\title{Conditional Removal of Facets}
\usage{
cond_rm_facets(
  facets = NULL,
  facets_regex = NULL,
  ancestor_pos = 1,
  split = NULL,
  split_regex = NULL,
  value = NULL,
  value_regex = NULL,
  keep_matches = FALSE
)
}
\arguments{
\item{facets}{character or NULL. Vector of facet names to be removed
if condition(s) are met}

\item{facets_regex}{character(1). Regular expression to identify facet
names to be removed if condition(s) are met.}

\item{ancestor_pos}{numeric(1). Row in spl_context to check the condition
within. E.g., 1 represents the first split, 2 represents the second split
nested within the first, etc. NA specifies that the conditions
should be checked at all split levels. Negative integers indicate position
counting back from the current one, e.g., -1 indicates the direct parent
(most recent split before this one). Negative and positive/NA positions
cannot be mixed.}

\item{split}{character(1) or NULL. If specified, name of the split
at position \code{ancestor_pos} must be identical to this value for
the removal condition to be met.}

\item{split_regex}{character(1) or NULL. If specified, a regular expression
the name of the split at position \code{ancestor_pos} must match for
the removal condition to be met. Cannot be specified at the same time
as \code{split}.}

\item{value}{character(1) or NULL. If specified, split (facet) value
at position \code{ancestor_pos} must be identical to this value for
removal condition to be met.}

\item{value_regex}{character(1) or NULL. If specified, a regular expression
the value of the split at position \code{ancestor_pos} must match for
the removal condition to be met. Cannot be specified at the same time
as \code{value}.}

\item{keep_matches}{logical(1). Given the specified condition is met,
should the facets removed be those matching \code{facets}/\code{facets_regex}
(\code{FALSE}, the default), or those \emph{not} matching (\code{TRUE}).}
}
\value{
a function suitable for use in \code{make_split_fun}'s
\code{post} argument which encodes the specified condition.
}
\description{
Conditional Removal of Facets
}
\details{
Facet removal occurs when the specified condition(s)
on the split(s) and or value(s) are met within at least one
of the split_context rows indicated by \code{ancestor_pos}; otherwise
the set of facets is returned unchanged.

If facet removal is performed, either \emph{all} facets which match \code{facets} (or
\code{facets_regex} will be removed ( the default \code{keep_matches == FALSE}
case), or all \emph{non-matching} facets will be removed (when
\code{keep_matches_only == TRUE}).
}
\note{
A degenerate table is likely to be returned if all facets
are removed.
}
\examples{

rm_a_from_placebo <- cond_rm_facets(
  facets = "A",
  ancestor_pos = NA,
  value_regex = "Placeb",
  split = "ARM"
)
mysplit <- make_split_fun(post = list(rm_a_from_placebo))

lyt <- basic_table() |>
  split_cols_by("ARM") |>
  split_cols_by("STRATA1", split_fun = mysplit) |>
  analyze("AGE", mean, format = "xx.x")
build_table(lyt, ex_adsl)

rm_bc_from_combo <- cond_rm_facets(
  facets = c("B", "C"),
  ancestor_pos = -1,
  value_regex = "Combi"
)
mysplit2 <- make_split_fun(post = list(rm_bc_from_combo))

lyt2 <- basic_table() |>
  split_cols_by("ARM") |>
  split_cols_by("STRATA1", split_fun = mysplit2) |>
  analyze("AGE", mean, format = "xx.x")
tbl2 <- build_table(lyt2, ex_adsl)
tbl2

rm_bc_from_combo2 <- cond_rm_facets(
  facets_regex = "^A$",
  ancestor_pos = -1,
  value_regex = "Combi",
  keep_matches = TRUE
)
mysplit3 <- make_split_fun(post = list(rm_bc_from_combo2))

lyt3 <- basic_table() |>
  split_cols_by("ARM") |>
  split_cols_by("STRATA1", split_fun = mysplit3) |>
  analyze("AGE", mean, format = "xx.x")
tbl3 <- build_table(lyt3, ex_adsl)

stopifnot(identical(cell_values(tbl2), cell_values(tbl3)))
}
