% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_fasta}
\alias{read_fasta}
\title{Read a fasta file.}
\usage{
read_fasta(fasta_files, fai_files = NULL, cut_names = FALSE)
}
\arguments{
\item{fasta_files}{File name(s) of the fasta file(s).}

\item{fai_files}{File name(s) of the fasta index file(s).
Providing this argument speeds up the reading process significantly.
If this argument is provided, it must be the same length as the \code{fasta_files}
argument.
Defaults to \code{NULL}, which indicates the fasta file(s) is/are not indexed.}

\item{cut_names}{Boolean for whether to cut chromosome names at the first space.
This argument is ignored if \code{fai_file} is not \code{NULL}.
Defaults to \code{FALSE}.}
}
\value{
A \code{\link{ref_genome}} object.
}
\description{
Accepts uncompressed and gzipped fasta files.
}
