% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residual_cor.R
\name{plot_residual_cor}
\alias{plot_residual_cor}
\title{Plot the residual correlation matrix from a latent variable model (LVM).}
\usage{
plot_residual_cor(
  mod,
  prob = NULL,
  main = "Residual Correlation Matrix from LVM",
  cex.main = 1.5,
  diag = FALSE,
  type = "lower",
  method = "color",
  mar = c(1, 1, 3, 1),
  tl.srt = 45,
  tl.cex = 0.5,
  ...
)
}
\arguments{
\item{mod}{An object of class \code{"jSDM"}.}

\item{prob}{A numeric scalar in the interval \eqn{(0,1)} giving the target probability coverage of the intervals, by which to determine whether the correlations are "significant".
If \code{prob=0.95} is specified only significant correlations, whose \eqn{95\%} HPD interval does not contain zero, are represented. 
Defaults to \code{prob=NULL} to represent all correlations significant or not.}

\item{main}{Character, title of the graph.}

\item{cex.main}{Numeric, title's size.}

\item{diag}{Logical, whether display the correlation coefficients on the principal diagonal.}

\item{type}{Character, "full" (default), "upper" or "lower", display full matrix, lower triangular or upper triangular matrix.}

\item{method}{Character, the visualization method of correlation matrix to be used. Currently, it supports seven methods, named "circle" (default), "square", "ellipse", "number", "pie", "shade" and "color".}

\item{mar}{See \code{\link[graphics]{par}}}

\item{tl.srt}{Numeric, for text label string rotation in degrees, see \code{\link[graphics]{text}}.}

\item{tl.cex}{Numeric, for the size of text label (variable names).}

\item{...}{Further arguments passed to \code{\link[corrplot]{corrplot}} function}
}
\value{
No return value. Displays a reordered correlation matrix.
}
\description{
Plot the posterior mean estimator of residual correlation matrix reordered by first principal component using \code{\link[corrplot]{corrplot}} function from the package of the same name.
}
\examples{
library(jSDM)
# frogs data
data(frogs, package="jSDM")
# Arranging data
PA_frogs <- frogs[,4:12]
# Normalized continuous variables
 Env_frogs <- cbind(scale(frogs[,1]),frogs[,2],scale(frogs[,3]))
 colnames(Env_frogs) <- colnames(frogs[,1:3])
# Parameter inference
# Increase the number of iterations to reach MCMC convergence
mod<-jSDM_binomial_probit(# Response variable
                           presence_data = PA_frogs,
                           # Explanatory variables
                           site_formula = ~.,
                           site_data = Env_frogs,
                           n_latent=2,
                           site_effect="random",
                           # Chains
                           burnin=100,
                           mcmc=100,
                           thin=1,
                           # Starting values
                           alpha_start=0,
                           beta_start=0,
                           lambda_start=0,
                           W_start=0,
                           V_alpha=1,
                           # Priors
                           shape=0.1, rate=0.1,
                           mu_beta=0, V_beta=1,
                           mu_lambda=0, V_lambda=1,
                           # Various
                           seed=1234, verbose=1)
# Representation of residual correlation between species
plot_residual_cor(mod)
plot_residual_cor(mod, prob=0.95)
}
\references{
Taiyun Wei and Viliam Simko (2017). R package "corrplot": Visualization of a Correlation Matrix (Version 0.84)   

Warton, D. I.; Blanchet, F. G.; O'Hara, R. B.; O'Hara, R. B.; Ovaskainen, O.; Taskinen, S.; Walker, S. C. and Hui, F. K. C. (2015) So Many Variables: Joint Modeling in Community Ecology. \emph{Trends in Ecology & Evolution}, 30, 766-779.
}
\seealso{
\code{\link[corrplot]{corrplot}} \code{\link{jSDM-package}} \code{\link{jSDM_binomial_probit}} \cr
         \code{\link{jSDM_binomial_logit}} \code{\link{jSDM_poisson_log}}
}
\author{
Ghislain Vieilledent <ghislain.vieilledent@cirad.fr>

Jeanne Clément <jeanne.clement16@laposte.net>
}
\keyword{corrplot}
