% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_}
\alias{make_}
\title{Make a new graph}
\usage{
make_(...)
}
\arguments{
\item{...}{Parameters, see details below.}
}
\description{
This is a generic function for creating graphs.
}
\details{
\code{make_()} is a generic function for creating graphs.
For every graph constructor in igraph that has a \code{make_} prefix,
there is a corresponding function without the prefix: e.g.
for \code{\link[=make_ring]{make_ring()}} there is also \code{\link[=ring]{ring()}}, etc.

The same is true for the random graph samplers, i.e. for each
constructor with a \code{sample_} prefix, there is a corresponding
function without that prefix.

These shorter forms can be used together with \code{make_()}.
The advantage of this form is that the user can specify constructor
modifiers which work with all constructors. E.g. the
\code{\link[=with_vertex_]{with_vertex_()}} modifier adds vertex attributes
to the newly created graphs.

See the examples and the various constructor modifiers below.
}
\examples{
r <- make_(ring(10))
l <- make_(lattice(c(3, 3, 3)))

r2 <- make_(ring(10), with_vertex_(color = "red", name = LETTERS[1:10]))
l2 <- make_(lattice(c(3, 3, 3)), with_edge_(weight = 2))

ran <- sample_(degseq(c(3, 3, 3, 3, 3, 3), method = "configuration"), simplified())
degree(ran)
is_simple(ran)
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_empty_graph}()},
\code{\link{make_full_citation_graph}()},
\code{\link{make_full_graph}()},
\code{\link{make_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()},
\code{\link{make_tree}()}

Constructor modifiers (and related functions)
\code{\link{sample_}()},
\code{\link{simplified}()},
\code{\link{with_edge_}()},
\code{\link{with_graph_}()},
\code{\link{with_vertex_}()},
\code{\link{without_attr}()},
\code{\link{without_loops}()},
\code{\link{without_multiples}()}
}
\concept{constructor modifiers}
\concept{deterministic constructors}
