% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{edge_attr_names}
\alias{edge_attr_names}
\title{List names of edge attributes}
\usage{
edge_attr_names(graph)
}
\arguments{
\item{graph}{The graph.}
}
\value{
Character vector, the names of the edge attributes.
}
\description{
List names of edge attributes
}
\examples{
g <- make_ring(10) \%>\%
  set_edge_attr("label", value = letters[1:10])
edge_attr_names(g)
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
