% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics-surface.R, R/freesurfer.R,
%   R/gifti.R
\name{imaging-surface}
\alias{imaging-surface}
\alias{read_surface}
\alias{write_surface}
\alias{io_read_fs}
\alias{io_read_gii}
\alias{io_write_gii}
\title{Read and write surface files}
\usage{
read_surface(file, format = "auto", type = NULL, ...)

write_surface(
  x,
  con,
  format = c("gifti", "freesurfer"),
  type = c("geometry", "annotations", "measurements", "color", "time_series"),
  ...,
  name = 1
)

io_read_fs(
  file,
  type = c("geometry", "annotations", "measurements"),
  format = "auto",
  name = basename(file),
  ...
)

io_read_gii(file)

io_write_gii(x, con, ...)
}
\arguments{
\item{file, con}{path the file}

\item{format}{format of the file, for \code{write_surface}, this is either
\code{'gifti'} or \code{'freesurfer'}; for \code{read_surface}, see
'Arguments' section in \code{\link[freesurferformats]{read.fs.surface}}
(when file type is \code{'geometry'}) and
\code{\link[freesurferformats]{read.fs.curv}}
(when file type is \code{'measurements'})}

\item{type}{type of the data; ignored if the file format is 'GIfTI'. For
'FreeSurfer' files, supported types are
\describe{
\item{\code{'geometry'}}{contains positions of mesh vertex nodes and face
indices;}
\item{\code{'annotations'}}{annotation file (usually with file extension
\code{'annot'}) containing a color look-up table and an array of color keys.
These files are used to display discrete values on the surface such as
brain atlas;}
\item{\code{'measurements'}}{measurement file such as \code{'sulc'} and
\code{'curv'} files, containing numerical values (often with continuous
domain) for each vertex node}
}}

\item{...}{for \code{read_surface}, the arguments will be passed to
\code{io_read_fs} if the file is a 'FreeSurfer' file.}

\item{x}{surface (geometry, annotation, measurement) data}

\item{name}{name of the data; for \code{io_read_fs}, this argument must be
a character, and default is the file name; for \code{write_surface}, this
argument can be an integer or a character, representing the
index or name of the corresponding measurement or annotation column.}
}
\value{
A surface object container for \code{read_surface}, and
the file path for \code{write_surface}
}
\description{
Supports surface geometry, annotation, measurement, and
time-series data.
Please use the high-level function \code{read_surface}, which calls
other low-level functions internally.
}
\examples{


library(ieegio)

# geometry
geom_file <- "gifti/GzipBase64/sujet01_Lwhite.surf.gii"

# measurements
shape_file <- "gifti/GzipBase64/sujet01_Lwhite.shape.gii"

# time series
ts_file <- "gifti/GzipBase64/fmri_sujet01_Lwhite_projection.time.gii"

if(ieegio_sample_data(geom_file, test = TRUE)) {

  geometry <- read_surface(ieegio_sample_data(geom_file))
  print(geometry)

  measurement <- read_surface(ieegio_sample_data(shape_file))
  print(measurement)

  time_series <- read_surface(ieegio_sample_data(ts_file))
  print(time_series)

  # merge measurement & time_series into geometry
  merged <- merge(geometry, measurement, time_series)
  print(merged)

  # make sure you install `rgl` package
  plot(merged, name = c("measurements", "Shape001"))

  plot(merged, name = "time_series",
       slice_index = c(1, 11, 21, 31))

}


}
